/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageListenerRedeliveryTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(MessageListenerRedeliveryTest.class);
    private Connection connection;

    protected void setUp() throws Exception {
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    protected RedeliveryPolicy getRedeliveryPolicy() {
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setInitialRedeliveryDelay(1000L);
        redeliveryPolicy.setMaximumRedeliveries(3);
        redeliveryPolicy.setBackOffMultiplier((short)2);
        redeliveryPolicy.setUseExponentialBackOff(true);
        return redeliveryPolicy;
    }

    protected Connection createConnection() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        factory.setRedeliveryPolicy(this.getRedeliveryPolicy());
        return factory.createConnection();
    }

    public void testQueueRollbackConsumerListener() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        TextMessage message = this.createTextMessage(session);
        producer.send((Message)message);
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        ActiveMQMessageConsumer mc = (ActiveMQMessageConsumer)consumer;
        mc.setRedeliveryPolicy(this.getRedeliveryPolicy());
        TestMessageListener listener = new TestMessageListener(session);
        consumer.setMessageListener((MessageListener)listener);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)2, (int)listener.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)3, (int)listener.counter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)4, (int)listener.counter);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)5, (int)listener.counter);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)5, (int)listener.counter);
        session.close();
    }

    public void testQueueRollbackSessionListener() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        TextMessage message = this.createTextMessage(session);
        producer.send((Message)message);
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        ActiveMQMessageConsumer mc = (ActiveMQMessageConsumer)consumer;
        mc.setRedeliveryPolicy(this.getRedeliveryPolicy());
        TestMessageListener listener = new TestMessageListener(session);
        consumer.setMessageListener((MessageListener)listener);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)2, (int)listener.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)3, (int)listener.counter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)4, (int)listener.counter);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)5, (int)listener.counter);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MessageListenerRedeliveryTest.assertEquals((int)5, (int)listener.counter);
        session.close();
    }

    private TextMessage createTextMessage(Session session) throws JMSException {
        return session.createTextMessage("Hello");
    }

    private MessageProducer createProducer(Session session, Destination queue) throws JMSException {
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(this.getDeliveryMode());
        return producer;
    }

    protected int getDeliveryMode() {
        return 2;
    }

    private class TestMessageListener
    implements MessageListener {
        public int counter;
        private Session session;

        public TestMessageListener(Session session) {
            this.session = session;
        }

        public void onMessage(Message message) {
            try {
                LOG.info((Object)("Message Received: " + message));
                ++this.counter;
                if (this.counter <= 4) {
                    LOG.info((Object)"Message Rollback.");
                    this.session.rollback();
                } else {
                    LOG.info((Object)"Message Commit.");
                    message.acknowledge();
                    this.session.commit();
                }
            }
            catch (JMSException e) {
                LOG.error((Object)"Error when rolling back transaction");
            }
        }
    }
}

