/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQXAConnectionFactoryTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(ActiveMQXAConnectionFactoryTest.class);

    public void testCopy() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?");
        ActiveMQConnectionFactory copy = cf.copy();
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an ActiveMQXAConnectionFactory", (boolean)(copy instanceof ActiveMQXAConnectionFactory));
    }

    public void testUseURIToSetOptionsOnConnectionFactory() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?jms.useAsyncSend=true");
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQXAConnectionFactory("vm://localhost?jms.useAsyncSend=false");
        ActiveMQXAConnectionFactoryTest.assertFalse((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQXAConnectionFactory("vm:(broker:()/localhost)?jms.useAsyncSend=true");
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm:(broker:()/localhost)", (String)cf.getBrokerURL());
    }

    public void testCreateVMConnectionWithEmbdeddBroker() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQXAConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        Connection connection = cf.createConnection();
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        connection.close();
        ActiveMQXAConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
    }

    public void testGetBrokerName() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        String brokerName = connection.getBrokerName();
        LOG.info((Object)("Got broker name: " + brokerName));
        ActiveMQXAConnectionFactoryTest.assertNotNull((String)"No broker name available!", (Object)brokerName);
        connection.close();
    }

    public void testCreateTcpConnectionUsingAllocatedPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testCreateTcpConnectionUsingKnownPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testIsSameRM() throws URISyntaxException, JMSException, XAException {
        ActiveMQXAConnectionFactory cf1 = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        XAConnection connection1 = (XAConnection)cf1.createConnection();
        XASession session1 = connection1.createXASession();
        XAResource resource1 = session1.getXAResource();
        ActiveMQXAConnectionFactory cf2 = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        XAConnection connection2 = (XAConnection)cf2.createConnection();
        XASession session2 = connection2.createXASession();
        XAResource resource2 = session2.getXAResource();
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)resource1.isSameRM(resource2));
        connection1.close();
        connection2.close();
    }

    protected void assertCreateConnection(String uri) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        TransportConnector connector = broker.addConnector(uri);
        broker.start();
        URI temp = new URI(uri);
        URI currentURI = connector.getServer().getConnectURI();
        URI connectURI = new URI(temp.getScheme(), temp.getUserInfo(), temp.getHost(), currentURI.getPort(), temp.getPath(), temp.getQuery(), temp.getFragment());
        LOG.info((Object)("connection URI is: " + connectURI));
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory(connectURI);
        Connection connection = cf.createConnection();
        this.assertXAConnection(connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        connection.close();
        connection = cf.createXAConnection();
        this.assertXAConnection(connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        connection.close();
        broker.stop();
    }

    private void assertXAConnection(Connection connection) {
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XAConnection", (boolean)(connection instanceof XAConnection));
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XATopicConnection", (boolean)(connection instanceof XATopicConnection));
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XAQueueConnection", (boolean)(connection instanceof XAQueueConnection));
    }
}

