/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.fest.swing.GUITest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GUITests {
    public static boolean isGUITest(Class<?> type, Method method) {
        if (GUITests.isGUITest(type)) {
            return true;
        }
        if (GUITests.isGUITest(method)) {
            return true;
        }
        return GUITests.isSuperclassGUITest(type, method);
    }

    private static boolean isSuperclassGUITest(Class<?> type, Method method) {
        for (Class<?> superclass = type.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (GUITests.isGUITest(superclass)) {
                return true;
            }
            Method overriden = GUITests.method(superclass, method.getName(), method.getParameterTypes());
            if (overriden == null || !GUITests.isGUITest(overriden)) continue;
            return true;
        }
        return false;
    }

    private static Method method(Class<?> superclass, String methodName, Class<?>[] parameterTypes) {
        try {
            return superclass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isGUITest(AnnotatedElement annotatedElement) {
        GUITest annotation = annotatedElement.getAnnotation(GUITest.class);
        return annotation != null;
    }

    private GUITests() {
    }
}

