/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.script;

import abbot.finder.AWTHierarchy;
import abbot.finder.Hierarchy;
import abbot.script.Script;
import abbot.script.Step;
import abbot.script.StepRunner;
import abbot.util.AWTFixtureHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.fest.swing.ScreenLock;
import org.fest.swing.script.ScriptApprover;
import org.fest.swing.script.ScriptFailure;
import org.fest.util.Arrays;
import org.fest.util.Files;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptRunner {
    private static final Hierarchy DUMMY_HIERARCHY = new AWTHierarchy();
    private static Logger logger = Logger.getLogger(ScriptRunner.class.getName());
    private final List<String> scriptNames = new ArrayList<String>();
    private final List<String> successfulScripts = new ArrayList<String>();

    public ScriptRunner(String dirName, ScriptApprover ... approvers) {
        this(dirName, false, approvers);
    }

    public ScriptRunner(String dirName, boolean recurse, ScriptApprover ... approvers) {
        this(Files.fileNamesIn((String)dirName, (boolean)recurse), approvers);
    }

    public ScriptRunner(List<String> fileNames, ScriptApprover ... approvers) {
        this(fileNames.toArray(new String[fileNames.size()]), approvers);
    }

    public ScriptRunner(String[] fileNames, ScriptApprover ... approvers) {
        for (String fileName : fileNames) {
            File file = new File(fileName);
            if (!this.approved(file, approvers)) continue;
            this.scriptNames.add(file.getAbsolutePath());
        }
        if (this.scriptNames.isEmpty()) {
            throw new IllegalStateException("No scripts found");
        }
    }

    private boolean approved(File file, ScriptApprover[] approvers) {
        if (Arrays.isEmpty((Object[])approvers)) {
            return true;
        }
        for (ScriptApprover approver : approvers) {
            if (approver.approve(file)) continue;
            return false;
        }
        return true;
    }

    public void runScripts() {
        this.successfulScripts.clear();
        for (String scriptName : this.scriptNames) {
            this.runScript(scriptName);
        }
    }

    private void runScript(String scriptName) {
        ScreenLock.instance().acquire(this);
        StepRunner runner = new StepRunner(new AWTFixtureHelper());
        AWTHierarchy.setDefault((Hierarchy)runner.getHierarchy());
        Script script = new Script(scriptName, DUMMY_HIERARCHY);
        logger.info(Strings.concat((Object[])new Object[]{"Running ", Strings.quote((Object)script)}));
        try {
            runner.run((Step)script);
            this.successfulScripts.add(scriptName);
        }
        catch (Throwable t) {
            try {
                throw new ScriptFailure(scriptName, t);
            }
            catch (Throwable throwable) {
                logger.info(Strings.concat((Object[])new Object[]{Strings.quote((String)scriptName), " finished"}));
                ScreenLock.instance().release(this);
                throw throwable;
            }
        }
        logger.info(Strings.concat((Object[])new Object[]{Strings.quote((String)scriptName), " finished"}));
        ScreenLock.instance().release(this);
    }

    public String[] successfulScripts() {
        return this.successfulScripts.toArray(new String[this.successfulScripts.size()]);
    }
}

