/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import abbot.tester.JTextComponentTester;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.swing.RobotFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.TextInputFixture;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTextComponentFixture
extends ComponentFixture<JTextComponent>
implements TextInputFixture<JTextComponent> {
    public JTextComponentFixture(RobotFixture robot, String textComponentName) {
        super(robot, textComponentName, JTextComponent.class);
    }

    public JTextComponentFixture(RobotFixture robot, JTextComponent target) {
        super(robot, target);
    }

    public final JTextComponentFixture click() {
        return (JTextComponentFixture)super.click();
    }

    public final JTextComponentFixture focus() {
        return (JTextComponentFixture)super.focus();
    }

    public final JTextComponentFixture requireText(String expected) {
        Assertions.assertThat((String)this.text()).isEqualTo(expected);
        return this;
    }

    public final JTextComponentFixture enterText(String text) {
        this.focus();
        this.tester().actionKeyString(text);
        return this;
    }

    public final JTextComponentFixture deleteText() {
        ((JTextComponent)this.target).setText("");
        return this;
    }

    public final JTextComponentFixture pressKeys(int ... keyCodes) {
        this.doPressKeys(keyCodes);
        return this;
    }

    @Override
    public final String text() {
        return ((JTextComponent)this.target).getText();
    }

    public final JTextComponentFixture selectAll() {
        return this.selectText(0, ((JTextComponent)this.target).getDocument().getLength());
    }

    public final JTextComponentFixture select(String text) {
        int indexFound = this.text().indexOf(text);
        if (indexFound == -1) {
            return this;
        }
        return this.selectText(indexFound, indexFound + text.length());
    }

    public final JTextComponentFixture selectText(int start, int end) {
        if (Strings.isEmpty((String)this.text())) {
            return this;
        }
        this.textComponentTester().actionSelectText(this.target, start, end);
        return this;
    }

    private JTextComponentTester textComponentTester() {
        return this.testerCastedTo(JTextComponentTester.class);
    }

    public final JTextComponentFixture requireVisible() {
        return (JTextComponentFixture)super.requireVisible();
    }

    public final JTextComponentFixture requireNotVisible() {
        return (JTextComponentFixture)super.requireNotVisible();
    }

    public final JTextComponentFixture requireEmpty() {
        Assertions.assertThat((String)this.text()).isEmpty();
        return this;
    }

    public final JTextComponentFixture requireEnabled() {
        return (JTextComponentFixture)super.requireEnabled();
    }

    public final JTextComponentFixture requireDisabled() {
        return (JTextComponentFixture)super.requireDisabled();
    }
}

