/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import abbot.tester.FrameTester;
import abbot.util.Bugs;
import java.awt.Dimension;
import java.awt.Frame;
import org.fest.swing.Condition;
import org.fest.swing.RobotFixture;
import org.fest.swing.fixture.WindowFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameFixture
extends WindowFixture<Frame> {
    public FrameFixture(String name) {
        super(name, Frame.class);
    }

    public FrameFixture(RobotFixture robot, String name) {
        super(robot, name, Frame.class);
    }

    public FrameFixture(Frame target) {
        super(target);
    }

    public FrameFixture(RobotFixture robot, Frame target) {
        super(robot, target);
    }

    public final FrameFixture show() {
        return (FrameFixture)super.show();
    }

    public final FrameFixture show(Dimension size) {
        return (FrameFixture)super.show(size);
    }

    public FrameFixture click() {
        return (FrameFixture)super.click();
    }

    public FrameFixture focus() {
        return (FrameFixture)super.focus();
    }

    public final FrameFixture iconify() {
        this.frameTester().iconify((Frame)this.target);
        this.robot.wait(new Condition("frame being iconified"){

            public boolean test() {
                return ((Frame)FrameFixture.this.target).getExtendedState() == 1;
            }
        });
        return this;
    }

    public final FrameFixture deiconify() {
        this.frameTester().deiconify((Frame)this.target);
        this.robot.wait(new Condition("frame being deiconified"){

            public boolean test() {
                return ((Frame)FrameFixture.this.target).getExtendedState() != 1;
            }
        });
        return this;
    }

    public final FrameFixture maximize() {
        this.frameTester().maximize((Frame)this.target);
        this.robot.wait(new Condition("frame being maximized"){

            public boolean test() {
                return (((Frame)FrameFixture.this.target).getExtendedState() & 6) == 6;
            }
        });
        return this;
    }

    public final FrameFixture normalize() {
        this.robot.invokeLater(this.target, new Runnable(){

            public void run() {
                ((Frame)FrameFixture.this.target).setExtendedState(0);
                if (Bugs.hasFrameDeiconifyBug()) {
                    ((Frame)FrameFixture.this.target).setVisible(true);
                }
            }
        });
        this.robot.wait(new Condition("frame being normalized"){

            public boolean test() {
                return ((Frame)FrameFixture.this.target).getExtendedState() == 0;
            }
        });
        return this;
    }

    private FrameTester frameTester() {
        return this.testerCastedTo(FrameTester.class);
    }

    public final FrameFixture resizeWidthTo(int width) {
        return (FrameFixture)super.resizeWidthTo(width);
    }

    public final FrameFixture resizeHeightTo(int height) {
        return (FrameFixture)super.resizeHeightTo(height);
    }

    public final FrameFixture resizeTo(Dimension size) {
        return (FrameFixture)super.resizeTo(size);
    }

    public final FrameFixture requireSize(Dimension size) {
        return (FrameFixture)super.requireSize(size);
    }

    @Override
    public final FrameFixture requireVisible() {
        return (FrameFixture)super.requireVisible();
    }

    public final FrameFixture requireNotVisible() {
        return (FrameFixture)super.requireNotVisible();
    }

    public final FrameFixture requireEnabled() {
        return (FrameFixture)super.requireEnabled();
    }

    public final FrameFixture requireDisabled() {
        return (FrameFixture)super.requireDisabled();
    }
}

