/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectArrayAssert
extends GroupAssert<Object[]> {
    ObjectArrayAssert(Object ... actual) {
        super(actual);
    }

    public ObjectArrayAssert isNotNull() {
        super.isNotNull();
        return this;
    }

    @Override
    public void isEmpty() {
        if (this.actualGroupSize() > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((Object[])this.actual), ">"}));
        }
    }

    public ObjectArrayAssert isNotEmpty() {
        if (this.actualGroupSize() == 0) {
            Fail.fail("expecting a non-empty array");
        }
        return this;
    }

    public ObjectArrayAssert isEqualTo(Object[] expected) {
        if (!Arrays.equals((Object[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((Object[])this.actual)));
        }
        return this;
    }

    public ObjectArrayAssert isNotEqualTo(Object[] array) {
        if (Arrays.equals((Object[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((Object[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((Object[])this.actual).length;
    }

    public ObjectArrayAssert hasSize(int expected) {
        return (ObjectArrayAssert)super.hasSize(expected);
    }

    public ObjectArrayAssert isSameAs(Object[] expected) {
        return (ObjectArrayAssert)super.isSameAs(expected);
    }

    public ObjectArrayAssert isNotSameAs(Object[] expected) {
        return (ObjectArrayAssert)super.isNotSameAs(expected);
    }
}

