/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveFail;

public final class IntAssert {
    private int actual;

    IntAssert(int actual) {
        this.actual = actual;
    }

    public IntAssert isEqualTo(int expected) {
        PrimitiveFail.failIfNotEqual(this.actual, expected);
        return this;
    }

    public IntAssert isNotEqualTo(int other) {
        PrimitiveFail.failIfEqual(this.actual, other);
        return this;
    }

    public IntAssert isGreaterThan(int smaller) {
        PrimitiveFail.failIfNotGreaterThan(this.actual, smaller);
        return this;
    }

    public IntAssert isLessThan(int bigger) {
        PrimitiveFail.failIfNotLessThan(this.actual, bigger);
        return this;
    }

    public IntAssert isPositive() {
        return this.isGreaterThan(0);
    }

    public IntAssert isNegative() {
        return this.isLessThan(0);
    }

    public IntAssert isZero() {
        return this.isEqualTo(0);
    }
}

