/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntArrayAssert
extends GroupAssert<int[]> {
    IntArrayAssert(int ... actual) {
        super(actual);
    }

    public IntArrayAssert isNotNull() {
        return (IntArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((int[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((int[])this.actual), ">"}));
        }
    }

    public IntArrayAssert isNotEmpty() {
        if (((int[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public IntArrayAssert isEqualTo(int[] expected) {
        if (!Arrays.equals((int[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((int[])this.actual)));
        }
        return this;
    }

    public IntArrayAssert isNotEqualTo(int[] array) {
        if (Arrays.equals((int[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((int[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((int[])this.actual).length;
    }

    public IntArrayAssert hasSize(int expected) {
        return (IntArrayAssert)super.hasSize(expected);
    }

    public IntArrayAssert isSameAs(int[] expected) {
        return (IntArrayAssert)super.isSameAs(expected);
    }

    public IntArrayAssert isNotSameAs(int[] expected) {
        return (IntArrayAssert)super.isNotSameAs(expected);
    }
}

