/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatArrayAssert
extends GroupAssert<float[]> {
    FloatArrayAssert(float ... actual) {
        super(actual);
    }

    public FloatArrayAssert isNotNull() {
        return (FloatArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((float[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((float[])this.actual), ">"}));
        }
    }

    public FloatArrayAssert isNotEmpty() {
        if (((float[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public FloatArrayAssert isEqualTo(float[] expected) {
        if (!Arrays.equals((float[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((float[])this.actual)));
        }
        return this;
    }

    public FloatArrayAssert isNotEqualTo(float[] array) {
        if (Arrays.equals((float[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((float[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((float[])this.actual).length;
    }

    public FloatArrayAssert hasSize(int expected) {
        return (FloatArrayAssert)super.hasSize(expected);
    }

    public FloatArrayAssert isSameAs(float[] expected) {
        return (FloatArrayAssert)super.isSameAs(expected);
    }

    public FloatArrayAssert isNotSameAs(float[] expected) {
        return (FloatArrayAssert)super.isNotSameAs(expected);
    }
}

