/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Fail;
import org.fest.assertions.PrimitiveFail;

public class DoubleAssert {
    private static final double ZERO = 0.0;
    private final double actual;

    DoubleAssert(double actual) {
        this.actual = actual;
    }

    public DoubleAssert isEqualTo(double expected) {
        PrimitiveFail.failIfNotEqual(this.actual, expected);
        return this;
    }

    public DoubleAssert isNotEqualTo(double other) {
        PrimitiveFail.failIfEqual(this.actual, other);
        return this;
    }

    public DoubleAssert isGreaterThan(double smaller) {
        PrimitiveFail.failIfNotGreaterThan(this.actual, smaller);
        return this;
    }

    public DoubleAssert isLessThan(double bigger) {
        PrimitiveFail.failIfNotLessThan(this.actual, bigger);
        return this;
    }

    public DoubleAssert isPositive() {
        return this.isGreaterThan(0.0);
    }

    public DoubleAssert isNegative() {
        return this.isLessThan(0.0);
    }

    public DoubleAssert isZero() {
        return this.isEqualTo(0.0);
    }

    public DoubleAssert isNaN() {
        return this.isEqualTo(Double.NaN);
    }

    public WithDelta withDelta(double delta) {
        return new WithDelta(this.actual, delta, this);
    }

    public static class WithDelta {
        private final double actual;
        private final double delta;
        private final DoubleAssert doubleAssert;

        WithDelta(double actual, double delta, DoubleAssert doubleAssert) {
            this.actual = actual;
            this.delta = delta;
            this.doubleAssert = doubleAssert;
        }

        public DoubleAssert isEqualTo(double expected) {
            if (Double.compare(expected, this.actual) == 0) {
                return this.doubleAssert;
            }
            if (!(Math.abs(expected - this.actual) <= this.delta)) {
                Fail.fail(PrimitiveFail.errorMessageIfNotEqual(this.actual, expected));
            }
            return this.doubleAssert;
        }
    }
}

