/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebClient
implements HttpSessionActivationListener,
HttpSessionBindingListener,
Externalizable {
    public static final String WEB_CLIENT_ATTRIBUTE = "org.apache.activemq.webclient";
    public static final String CONNECTION_FACTORY_ATTRIBUTE = "org.apache.activemq.connectionFactory";
    public static final String CONNECTION_FACTORY_PREFETCH_PARAM = "org.apache.activemq.connectionFactory.prefetch";
    public static final String CONNECTION_FACTORY_OPTIMIZE_ACK_PARAM = "org.apache.activemq.connectionFactory.optimizeAck";
    public static final String BROKER_URL_INIT_PARAM = "org.apache.activemq.brokerURL";
    private static final Log LOG = LogFactory.getLog(WebClient.class);
    private static transient ConnectionFactory factory;
    private transient Map<Destination, MessageConsumer> consumers = new HashMap<Destination, MessageConsumer>();
    private transient Connection connection;
    private transient Session session;
    private transient MessageProducer producer;
    private int deliveryMode = 1;
    private final Semaphore semaphore = new Semaphore(1);

    public WebClient() {
        if (factory == null) {
            throw new IllegalStateException("initContext(ServletContext) not called");
        }
    }

    public static WebClient getWebClient(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        WebClient client = WebClient.getWebClient(session);
        if (client == null || client.isClosed()) {
            client = WebClient.createWebClient(request);
            session.setAttribute(WEB_CLIENT_ATTRIBUTE, (Object)client);
        }
        return client;
    }

    public static WebClient getWebClient(HttpSession session) {
        return (WebClient)session.getAttribute(WEB_CLIENT_ATTRIBUTE);
    }

    public static void initContext(ServletContext context) {
        WebClient.initConnectionFactory(context);
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public synchronized void closeConsumers() {
        Iterator<MessageConsumer> it = this.consumers.values().iterator();
        while (it.hasNext()) {
            MessageConsumer consumer = it.next();
            it.remove();
            try {
                consumer.setMessageListener(null);
                if (consumer instanceof MessageAvailableConsumer) {
                    ((MessageAvailableConsumer)consumer).setAvailableListener(null);
                }
                consumer.close();
            }
            catch (JMSException e) {
                LOG.debug((Object)"caught exception closing consumer", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            this.closeConsumers();
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            LOG.debug((Object)"caught exception closing consumer", (Throwable)e);
        }
        finally {
            this.producer = null;
            this.session = null;
            this.connection = null;
            if (this.consumers != null) {
                this.consumers.clear();
            }
            this.consumers = null;
        }
    }

    public boolean isClosed() {
        return this.consumers == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.consumers != null) {
            out.write(this.consumers.size());
            Iterator<Destination> i = this.consumers.keySet().iterator();
            while (i.hasNext()) {
                out.writeObject(i.next().toString());
            }
        } else {
            out.write(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size >= 0) {
            this.consumers = new HashMap<Destination, MessageConsumer>();
            for (int i = 0; i < size; ++i) {
                String destinationName = in.readObject().toString();
                try {
                    Topic destination = destinationName.startsWith("topic://") ? this.getSession().createTopic(destinationName) : this.getSession().createQueue(destinationName);
                    this.consumers.put((Destination)destination, this.getConsumer((Destination)destination, true));
                    continue;
                }
                catch (JMSException e) {
                    LOG.debug((Object)"Caought Exception ", (Throwable)e);
                    IOException ex = new IOException(e.getMessage());
                    ex.initCause(e.getCause() != null ? e.getCause() : e);
                    throw ex;
                }
            }
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.getProducer().send(destination, message);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sent! to destination: " + destination + " message: " + message));
        }
    }

    public void send(Destination destination, Message message, boolean persistent, int priority, long timeToLive) throws JMSException {
        int deliveryMode = persistent ? 2 : 1;
        this.getProducer().send(destination, message, deliveryMode, priority, timeToLive);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sent! to destination: " + destination + " message: " + message));
        }
    }

    public Session getSession() throws JMSException {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = factory.createConnection();
            this.connection.start();
        }
        return this.connection;
    }

    protected static synchronized void initConnectionFactory(ServletContext servletContext) {
        if (factory == null) {
            factory = (ConnectionFactory)servletContext.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        }
        if (factory == null) {
            String brokerURL = servletContext.getInitParameter(BROKER_URL_INIT_PARAM);
            LOG.debug((Object)("Value of: org.apache.activemq.brokerURL is: " + brokerURL));
            if (brokerURL == null) {
                throw new IllegalStateException("missing brokerURL (specified via org.apache.activemq.brokerURL init-Param");
            }
            ActiveMQConnectionFactory amqfactory = new ActiveMQConnectionFactory(brokerURL);
            if (servletContext.getInitParameter(CONNECTION_FACTORY_PREFETCH_PARAM) != null) {
                int prefetch = Integer.valueOf(servletContext.getInitParameter(CONNECTION_FACTORY_PREFETCH_PARAM));
                amqfactory.getPrefetchPolicy().setAll(prefetch);
            }
            if (servletContext.getInitParameter(CONNECTION_FACTORY_OPTIMIZE_ACK_PARAM) != null) {
                boolean optimizeAck = Boolean.valueOf(servletContext.getInitParameter(CONNECTION_FACTORY_OPTIMIZE_ACK_PARAM));
                amqfactory.setOptimizeAcknowledge(optimizeAck);
            }
            factory = amqfactory;
            servletContext.setAttribute(CONNECTION_FACTORY_ATTRIBUTE, (Object)factory);
        }
    }

    public synchronized MessageProducer getProducer() throws JMSException {
        if (this.producer == null) {
            this.producer = this.getSession().createProducer(null);
            this.producer.setDeliveryMode(this.deliveryMode);
        }
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public synchronized MessageConsumer getConsumer(Destination destination) throws JMSException {
        return this.getConsumer(destination, true);
    }

    public synchronized MessageConsumer getConsumer(Destination destination, boolean create) throws JMSException {
        MessageConsumer consumer = this.consumers.get(destination);
        if (create && consumer == null) {
            consumer = this.getSession().createConsumer(destination);
            this.consumers.put(destination, consumer);
        }
        return consumer;
    }

    public synchronized void closeConsumer(Destination destination) throws JMSException {
        MessageConsumer consumer = this.consumers.get(destination);
        if (consumer != null) {
            this.consumers.remove(destination);
            consumer.setMessageListener(null);
            if (consumer instanceof MessageAvailableConsumer) {
                ((MessageAvailableConsumer)consumer).setAvailableListener(null);
            }
            consumer.close();
        }
    }

    public synchronized List<MessageConsumer> getConsumers() {
        return new ArrayList<MessageConsumer>(this.consumers.values());
    }

    protected Session createSession() throws JMSException {
        return this.getConnection().createSession(false, 1);
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        this.close();
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.close();
    }

    protected static WebClient createWebClient(HttpServletRequest request) {
        return new WebClient();
    }
}

