/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.frontend;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.frontend.EmbeddedJettyServer;
import fi.csc.microarray.frontend.FileBrokerConfig;
import fi.csc.microarray.frontend.JettyCheckTimerTask;
import fi.csc.microarray.util.FileCleanUpTimerTask;
import fi.csc.microarray.util.MemUtil;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class FileServer {
    private static final Logger logger = Logger.getLogger(FileServer.class);
    private static final String FILESERVER_CONTEXT_PATH = "/fileserver";

    public FileServer() throws Exception {
        boolean ok;
        File fileRepository = new File(MicroarrayConfiguration.getValue("frontend", "fileServerPath"));
        if (!fileRepository.exists() && !(ok = fileRepository.mkdir())) {
            throw new IOException("could not create file repository at " + fileRepository);
        }
        EmbeddedJettyServer fileServer = new EmbeddedJettyServer();
        int port = FileBrokerConfig.getPort();
        fileServer.start(fileRepository.getPath(), FILESERVER_CONTEXT_PATH, port);
        logger.info((Object)("fileserver is up and running [" + ApplicationConstants.NAMI_VERSION + "]"));
        logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
        int cutoff = 1000 * Integer.parseInt(MicroarrayConfiguration.getValue("frontend", "fileLifeTime"));
        int cleanUpFrequency = 1000 * Integer.parseInt(MicroarrayConfiguration.getValue("frontend", "cleanUpFrequency"));
        int checkFrequency = 5000;
        Timer t = new Timer("frontend-scheduled-tasks", true);
        t.schedule((TimerTask)new FileCleanUpTimerTask(fileRepository, cutoff), 0L, (long)cleanUpFrequency);
        t.schedule((TimerTask)new JettyCheckTimerTask(fileServer), 0L, (long)checkFrequency);
    }
}

