/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataManagerBase;
import fi.csc.microarray.databeans.fs.FSDataBean;
import fi.csc.microarray.databeans.fs.FSDataFolder;
import fi.csc.microarray.databeans.fs.FSSnapshottingSession;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.mortbay.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDataManager
extends DataManagerBase {
    private FSDataFolder rootFolder = (FSDataFolder)this.createFolder("Datasets");
    private File repositoryRoot = this.createRepository();

    public void setRootFolder(FSDataFolder folder) {
        this.rootFolder = folder;
    }

    @Override
    public DataFolder getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public DataFolder createFolder(String name) {
        FSDataFolder folder = new FSDataFolder(this, name);
        return folder;
    }

    @Override
    public DataFolder createFolder(DataFolder root, String name) {
        FSDataFolder folder = new FSDataFolder(this, name);
        root.addChild(folder);
        return folder;
    }

    @Override
    public DataBean createDataBean(String name) throws MicroarrayException {
        return this.createDataBean(name, null, new DataBean[0]);
    }

    @Override
    public DataBean createDataBean(String name, DataFolder folder, DataBean ... sources) throws MicroarrayException {
        File contentFile;
        try {
            contentFile = this.createNewRepositoryFile(name);
        }
        catch (IOException e) {
            throw new MicroarrayException(e);
        }
        return this.createDataBean(name, folder, sources, contentFile);
    }

    @Override
    public FSDataBean createDataBean(String name, InputStream content) throws MicroarrayException {
        return this.createDataBean(name, content, null, new DataBean[0]);
    }

    @Override
    public FSDataBean createDataBean(String name, InputStream content, DataFolder folder, DataBean ... sources) throws MicroarrayException {
        File contentFile;
        try {
            contentFile = this.createNewRepositoryFile(name);
            BufferedInputStream input = new BufferedInputStream(content);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(contentFile));
            IO.copy((InputStream)input, (OutputStream)output);
            ((InputStream)input).close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
        catch (IOException ioe) {
            throw new MicroarrayException(ioe);
        }
        FSDataBean bean = new FSDataBean(name, this.guessContentType(name), new Date(), sources, folder, this, contentFile);
        this.dispatchEventIfVisible(new DataItemCreatedEvent(bean));
        return bean;
    }

    public FSDataBean createDataBean(String name, File contentFile) throws MicroarrayException {
        return this.createDataBean(name, null, new DataBean[0], contentFile);
    }

    public FSDataBean createDataBean(String name, DataFolder folder, DataBean[] sources, File contentFile) throws MicroarrayException {
        FSDataBean dataBean = new FSDataBean(name, this.guessContentType(name), new Date(), sources, folder, this, contentFile);
        this.dispatchEventIfVisible(new DataItemCreatedEvent(dataBean));
        return dataBean;
    }

    public synchronized File createNewRepositoryFile(String beanName) throws IOException {
        String fileName = beanName.replaceAll("[^\\w\u00f6\u00e4\u00e5\u00d6\u00c4\u00c5\\\\.]", "");
        if (fileName.length() < 1) {
            fileName = "data";
        } else if (fileName.length() > 50) {
            fileName = fileName.substring(0, 50);
        }
        File file = new File(this.repositoryRoot, fileName);
        for (int i = 1; file.exists() && i < Integer.MAX_VALUE; ++i) {
            file = new File(this.repositoryRoot, fileName + "-" + i);
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create file " + fileName);
        }
        file.deleteOnExit();
        return file;
    }

    private File createRepository() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!(tempDir.canWrite() || (tempDir = new File(System.getProperty("user.home"))).canWrite() || (tempDir = new File(System.getProperty("user.dir"))).canWrite())) {
            throw new IOException("Could not create repository directory.");
        }
        String fileName = "chipster";
        File repository = new File(tempDir, fileName);
        boolean repositoryCreated = false;
        for (int i = 1; !repositoryCreated && i < 1000; ++i) {
            repositoryCreated = repository.mkdir();
            if (repositoryCreated) continue;
            repository = new File(tempDir, fileName + "-" + i);
        }
        if (!repositoryCreated) {
            throw new IOException("Could not create repository directory.");
        }
        repository.deleteOnExit();
        return repository;
    }

    @Override
    public List<DataItem> loadSnapshot(File snapshotDir, DataFolder parentFolder) throws IOException, MicroarrayException {
        FSSnapshottingSession session = new FSSnapshottingSession(this);
        List<DataItem> newItems = session.loadFromSnapshot(snapshotDir, parentFolder);
        return newItems;
    }

    @Override
    public int saveSnapshot(File snapshotDir) throws IOException {
        FSSnapshottingSession session = new FSSnapshottingSession(this);
        return session.saveSnapshot(snapshotDir);
    }
}

