/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.stat;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.ConstantTableFeature;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureFactoryBase;
import fi.csc.microarray.databeans.features.NonexistingFeature;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class SomClusterFactory
extends FeatureFactoryBase {
    public Feature createFeature(String namePostfix, DataBean bean) {
        if (!(bean.fetchFeature("/column/colours").exists() && bean.fetchFeature("/column/distance2first").exists() && bean.fetchFeature("/column/cluster").exists() && bean.fetchFeature("/column/ ").exists() && bean.fetchFeature("/column/griddim").exists())) {
            return new NonexistingFeature(bean, this);
        }
        try {
            HashMap<Integer, Cluster> clusterMap = new HashMap<Integer, Cluster>();
            Iterator<Float> dimensions = bean.fetchFeature("/column/griddim").asFloats().iterator();
            int width = dimensions.next().intValue();
            int height = dimensions.next().intValue();
            Iterator<String> colours = bean.fetchFeature("/column/colours").asStrings().iterator();
            Iterator<Float> distances = bean.fetchFeature("/column/distance2first").asFloats().iterator();
            int i = 1;
            while (true) {
                String colour = "";
                if (colours.hasNext()) {
                    colour = colours.next();
                }
                if ("".equals(colour.trim()) || "NaN".equals(colour)) break;
                Cluster cluster = new Cluster();
                cluster.number = i;
                cluster.colour = colour;
                cluster.distanceToFirst = distances.next().floatValue();
                clusterMap.put(i, cluster);
                ++i;
            }
            Iterable<Float> clusters = bean.fetchFeature("/column/cluster").asFloats();
            Iterator<String> genes = bean.fetchFeature("/column/ ").asStrings().iterator();
            for (Float clusterNumber : clusters) {
                int number = clusterNumber.intValue();
                Cluster cluster = (Cluster)clusterMap.get(number);
                if (cluster == null) {
                    throw new RuntimeException("illegal SOM dataset \"" + bean.getName() + "\": cluster " + number + " was referenced, but does not exist");
                }
                cluster.values = cluster.values + " " + genes.next();
            }
            LinkedList<Integer> xColumn = new LinkedList<Integer>();
            LinkedList<Integer> yColumn = new LinkedList<Integer>();
            LinkedList<String> colorColumn = new LinkedList<String>();
            LinkedList<String> vectorColumn = new LinkedList<String>();
            LinkedList<String> valuesColumn = new LinkedList<String>();
            Iterator clusterIter = clusterMap.values().iterator();
            for (int x = 1; x < width + 1; ++x) {
                for (int y = 1; y < height + 1; ++y) {
                    Cluster cluster = (Cluster)clusterIter.next();
                    xColumn.add(x);
                    yColumn.add(y);
                    colorColumn.add(cluster.colour);
                    vectorColumn.add("" + cluster.distanceToFirst);
                    valuesColumn.add(cluster.values);
                }
            }
            String[] columns = new String[]{"x", "y", "color", "vector", "values"};
            Object[][] values = new Object[][]{xColumn.toArray(new Integer[0]), yColumn.toArray(new Integer[0]), colorColumn.toArray(new String[0]), vectorColumn.toArray(new String[0]), valuesColumn.toArray(new String[0])};
            return new ConstantTableFeature(bean, this, columns, values);
        }
        catch (MicroarrayException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Cluster {
        String colour;
        int number;
        float distanceToFirst;
        String values = "";

        private Cluster() {
        }
    }
}

