/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.biobeans;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.databeans.features.table.EditableTable;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class PhenodataTest {
    private DataManager manager;

    @BeforeSuite(alwaysRun=true)
    public void init() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        this.manager = new FSDataManager();
        ApplicationConstants.plugFeatures(this.manager);
    }

    @Test(groups={"smoke"})
    public void testPhenodataRetrieval() throws MicroarrayException, IOException {
        DataBean normalised = this.manager.createDataBean("normalised.tsv");
        DataBean filtered = this.manager.createDataBean("filtered.tsv");
        DataBean phenodata = this.manager.createDataBean("phenodata.tsv");
        filtered.addLink(DataBean.Link.DERIVATION, normalised);
        phenodata.addLink(DataBean.Link.ANNOTATION, normalised);
        Assert.assertEquals((Object)phenodata, (Object)LinkUtils.retrieveInherited(normalised, DataBean.Link.ANNOTATION));
        Assert.assertEquals((Object)phenodata, (Object)LinkUtils.retrieveInherited(filtered, DataBean.Link.ANNOTATION));
    }

    @Test(groups={"smoke"})
    public void testPhenodataGeneration() throws MicroarrayException, IOException {
        DataBean normalised1 = this.manager.createDataBean("normalised.tsv");
        DataBean phenodata1 = this.manager.createDataBean("phenodata.tsv");
        DataBean filtered = this.manager.createDataBean("filtered.tsv");
        filtered.addLink(DataBean.Link.DERIVATION, normalised1);
        phenodata1.addLink(DataBean.Link.ANNOTATION, normalised1);
        DataBean normalised2 = this.manager.createDataBean("normalised.tsv");
        DataBean phenodata2 = this.manager.createDataBean("phenodata.tsv");
        phenodata2.addLink(DataBean.Link.ANNOTATION, normalised2);
        ArrayList<String> samples = new ArrayList<String>();
        ArrayList<String> originals = new ArrayList<String>();
        ArrayList<String> group = new ArrayList<String>();
        ArrayList<String> training = new ArrayList<String>();
        ArrayList<String> chiptypes = new ArrayList<String>();
        samples.add("microarray1.cel");
        originals.add("affy_example1.cel");
        group.add("1");
        training.add("0");
        chiptypes.add("test3");
        samples.add("microarray2.cel");
        originals.add("affy_example2.cel");
        group.add("2");
        training.add("0");
        chiptypes.add("test3");
        EditableTable matrix = new EditableTable();
        matrix.addColumn("sample", samples);
        matrix.addColumn("original_name", originals);
        matrix.addColumn("group", group);
        matrix.addColumn("training", training);
        matrix.addColumn("chiptype", chiptypes);
        OutputStream out = phenodata1.getContentOutputStreamAndLockDataBean();
        matrix.writeTo(out);
        phenodata1.closeContentOutputStreamAndUnlockDataBean(out);
        group.set(0, "");
        matrix.removeColumn("group");
        matrix.addColumn("group", group);
        matrix.removeColumn("original_name");
        out = phenodata2.getContentOutputStreamAndLockDataBean();
        matrix.writeTo(out);
        phenodata2.closeContentOutputStreamAndUnlockDataBean(out);
        Assert.assertTrue((boolean)phenodata1.fetchFeature("/phenodata").exists());
        Assert.assertTrue((boolean)phenodata1.fetchFeature("/phenodata/is-complete").exists());
        Assert.assertEquals((String)phenodata1.fetchFeature("/phenodata/sample_to_name/microarray1.cel").asString(), (String)"affy_example1.cel");
        Assert.assertTrue((boolean)phenodata2.fetchFeature("/phenodata").exists());
        Assert.assertFalse((boolean)phenodata2.fetchFeature("/phenodata/is-complete").exists());
        Assert.assertEquals((String)phenodata2.fetchFeature("/phenodata/sample_to_name/microarray1.cel").asString(), (String)"microarray1.cel");
        Assert.assertTrue((boolean)normalised1.fetchFeature("/phenodata/linked").exists());
        Assert.assertTrue((boolean)filtered.fetchFeature("/phenodata/linked/is-complete").exists());
        Assert.assertEquals((String)normalised1.fetchFeature("/phenodata/linked/sample_to_name/microarray1.cel").asString(), (String)"affy_example1.cel");
        Assert.assertTrue((boolean)normalised2.fetchFeature("/phenodata/linked").exists());
    }
}

