/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationToolBar;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.MultiChartPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Visualisation {
    private static final Logger logger = Logger.getLogger(Visualisation.class);
    public static final Dimension PARAMETER_SIZE = new Dimension(150, 500);

    public abstract JComponent getVisualisation(DataBean var1, Dimension var2) throws Exception;

    public abstract boolean canVisualise(DataBean var1) throws MicroarrayException;

    public JPanel getParameterPanel() {
        return null;
    }

    protected JComponent getDefaultVisualisation() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        return panel;
    }

    protected void setHelpAddress(String address) {
        JToolBar toolBar = ((SwingClientApplication)Session.getSession().getApplication()).getVisualisationFrame().getToolBar();
        ((VisualisationToolBar)toolBar).setHelpAddress(address);
    }

    public Variable[] getVariablesFor(DataBean dataBean) throws MicroarrayException {
        LinkedList<Variable> vars = new LinkedList<Variable>();
        if (this == VisualisationMethod.SCATTERPLOT.getVisualiser() || this == VisualisationMethod.HISTOGRAM.getVisualiser()) {
            this.extractChips(dataBean, vars);
        }
        logger.debug((Object)("returning " + vars + " variables from " + dataBean.getName()));
        return vars.toArray(new Variable[0]);
    }

    private void extractChips(DataBean dataBean, LinkedList<Variable> vars) throws MicroarrayException {
        String exprHeader = "/column/";
        String chipHeader = "chip.";
        Table columns = dataBean.fetchFeature("/column/*").asTable();
        for (String columnName : columns.getColumnNames()) {
            logger.debug((Object)("is chip name " + columnName + ": " + columnName.startsWith(chipHeader)));
            if (!columnName.startsWith(chipHeader)) continue;
            String chipName = columnName.substring(chipHeader.length());
            String expression = exprHeader + columnName;
            vars.add(new Variable(chipName, expression));
        }
    }

    protected JComponent makePanel(List<JFreeChart> charts, Dimension size) {
        int slots;
        int height = slots = (int)Math.ceil(Math.sqrt(charts.size()));
        int width = slots * (slots - 1) >= charts.size() ? slots - 1 : slots;
        JPanel panel = new JPanel(new GridLayout(width, height));
        LinkedList<MultiChartPanel> panels = new LinkedList<MultiChartPanel>();
        for (JFreeChart chart : charts) {
            MultiChartPanel multiPanel = new MultiChartPanel(chart, panels);
            panels.add(multiPanel);
            panel.add((Component)multiPanel);
        }
        panel.setPreferredSize(size);
        return panel;
    }

    protected ChartPanel makePanel(JFreeChart chart, Dimension size) {
        int width = (int)size.getWidth();
        int height = (int)size.getHeight();
        ChartPanel panel = new ChartPanel(chart, width, height, width, height, width, height, true, true, true, true, true, true);
        chart.getTitle().setFont(VisualConstants.VISUALISATION_TITLE_FONT);
        return panel;
    }

    public static class PlotDescription {
        public String plotTitle;
        public String xTitle;
        public String yTitle;

        public PlotDescription(String plotTitle, String xTitle, String yTitle) {
            this.plotTitle = plotTitle;
            this.xTitle = xTitle;
            this.yTitle = yTitle;
        }
    }

    public static class Variable {
        private String name;
        private String expression;

        public Variable(String name, String expression) {
            this.name = name;
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

