/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;

public class IntegerParameter
extends Parameter {
    private int minValue;
    private int maxValue;
    private int value;

    public IntegerParameter(String name, String description, int minValue, int maxValue, int initValue) throws IllegalArgumentException {
        super(name, description);
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new IllegalArgumentException("Minimum value for integer parameter " + this.getName() + " cannot be bigger than the maximum value.");
        }
        this.maxValue = maxValue;
        this.setIntegerValue(initValue);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getIntegerValue() {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setMinValue(int newMinValue) {
        if (newMinValue > this.maxValue) {
            throw new IllegalArgumentException("New minimum value for " + this.getName() + " cannot exceed current maximum value.");
        }
        this.minValue = newMinValue;
        if (this.value < this.minValue) {
            this.value = this.minValue;
        }
    }

    public void setMaxValue(int newMaxValue) {
        if (newMaxValue < this.minValue) {
            throw new IllegalArgumentException("New maximum value for " + this.getName() + " cannot fall below current minimum value.");
        }
        this.maxValue = newMaxValue;
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
    }

    public void setIntegerValue(int newValue) throws IllegalArgumentException {
        if (newValue < this.minValue || newValue > this.maxValue) {
            throw new IllegalArgumentException("New value for integer parameter " + this.getName() + " must be inside given limits.");
        }
        this.value = newValue;
    }

    public void setValue(Object newValue) throws IllegalArgumentException {
        if (!(newValue instanceof Integer)) {
            throw new IllegalArgumentException(newValue + " is an illegal " + "value for integer parameter " + this.getName() + ".");
        }
        this.setIntegerValue((Integer)newValue);
    }

    public boolean checkValidityOf(Object valueObject) {
        if (!(valueObject instanceof Integer)) {
            return false;
        }
        Integer intValue = (Integer)valueObject;
        return intValue >= this.minValue && intValue <= this.maxValue;
    }

    public String toString() {
        return this.getName() + ": " + this.value;
    }

    public String getValueAsJava() {
        return "" + this.value;
    }
}

