/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.data.AbstractGraphVertex;
import fi.csc.microarray.client.data.GraphVertex;
import fi.csc.microarray.client.data.GroupVertex;
import fi.csc.microarray.client.data.PhenodataVertex;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.VertexRenderer;

public class GraphRenderer
extends VertexRenderer {
    public static Rectangle handle = new Rectangle(0, 0, 7, 7);
    public static Rectangle phenodata = new Rectangle(0, 0, 0, 0);
    protected boolean isGroup = false;
    protected boolean isPhenodata = false;
    protected boolean isSelected = false;
    protected Color handleColor = Color.white;
    protected Color graphForeground = Color.black;
    private JGraph graph;
    private AbstractGraphVertex vertex;

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.isSelected = sel;
        this.handleColor = graph.getHandleColor();
        this.graphForeground = graph.getForeground();
        this.isGroup = view.getCell() instanceof GroupVertex;
        this.isPhenodata = view.getCell() instanceof PhenodataVertex;
        if (view.getCell() instanceof AbstractGraphVertex) {
            this.vertex = this.isGroup ? (GroupVertex)((Object)view.getCell()) : (this.isPhenodata ? (PhenodataVertex)((Object)view.getCell()) : (GraphVertex)((Object)view.getCell()));
        }
        this.graph = graph;
        return super.getRendererComponent(graph, view, sel, focus, preview);
    }

    public void paint(Graphics g) {
        if (this.isGroup) {
            if (this.hasFocus || this.selected) {
                this.setFont(this.getFont().deriveFont(1));
            }
        } else if (this.selected) {
            this.setFont(this.getFont().deriveFont(1));
        }
        if (this.isPhenodata) {
            int b = this.borderWidth;
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            if (super.isOpaque()) {
                g.setColor(super.getBackground());
                if (this.gradientColor != null && !this.preview) {
                    this.setOpaque(false);
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                }
                g.fillOval(b - 1, b - 1, d.width - b, d.height - b);
            }
            this.setBorder(null);
            super.paint(g);
            if (!this.selected) {
                g.setColor(this.bordercolor);
                g2.setStroke(new BasicStroke(b));
                g.drawOval(0, 0, d.width - 1, d.height - 1);
            }
        } else {
            super.paint(g);
        }
        if (this.isGroup) {
            g.setColor(this.handleColor);
            g.fill3DRect(GraphRenderer.handle.x, GraphRenderer.handle.y, GraphRenderer.handle.width, GraphRenderer.handle.height, true);
            g.setColor(this.graphForeground);
            g.drawRect(GraphRenderer.handle.x, GraphRenderer.handle.y, GraphRenderer.handle.width, GraphRenderer.handle.height);
            g.drawLine(GraphRenderer.handle.x + 1, GraphRenderer.handle.y + GraphRenderer.handle.height / 2, GraphRenderer.handle.x + GraphRenderer.handle.width - 2, GraphRenderer.handle.y + GraphRenderer.handle.height / 2);
            if (this.view.isLeaf()) {
                g.drawLine(GraphRenderer.handle.x + GraphRenderer.handle.width / 2, GraphRenderer.handle.y + 1, GraphRenderer.handle.x + GraphRenderer.handle.width / 2, GraphRenderer.handle.y + GraphRenderer.handle.height - 2);
            }
        }
        if (this.isPhenodata && !((PhenodataVertex)this.vertex).isPhenodataSet()) {
            ImageIcon icon = VisualConstants.PHENODATA_ICON;
            double iconHeight = icon.getIconHeight();
            double iconWidth = icon.getIconWidth();
            Dimension d = this.getSize();
            Image img = icon.getImage();
            double xPos = 2.4f;
            double yPos = 1.3f;
            g.setClip((int)(g.getClipBounds().getX() - iconWidth / xPos), (int)g.getClipBounds().getY(), (int)(g.getClipBounds().getWidth() + iconWidth / (1.0 / xPos)), (int)(g.getClipBounds().getHeight() + iconHeight / (1.0 / yPos)));
            g.drawImage(img, (int)(-iconWidth / xPos), (int)(d.getHeight() - iconHeight / yPos), (int)iconWidth, (int)iconHeight, (ImageObserver)this.graph);
            phenodata.setBounds(new Rectangle((int)(-iconWidth / xPos), (int)(d.getHeight() - iconHeight / yPos), (int)iconWidth, (int)iconHeight));
        }
    }

    public void paintSelectionBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke previousStroke = g2.getStroke();
        boolean paintBorders = false;
        if (this.isGroup && (this.hasFocus || this.childrenSelected)) {
            if (((GroupVertex)((Object)this.view.getCell())).isCollapsed()) {
                g2.setStroke(GroupVertex.COLLAPSED_SELECTION_STROKE);
                g.setColor(GroupVertex.COLLAPSED_SELECTED_BORDER_COLOR);
                paintBorders = true;
            } else {
                g2.setStroke(GroupVertex.EXPANDED_SELECTION_STROKE);
                g.setColor(GroupVertex.EXPANDED_SELECTED_BORDER_COLOR);
                paintBorders = true;
            }
        } else if (this.selected) {
            g2.setStroke(GraphVertex.SELECTION_STROKE);
            g.setColor(GraphVertex.SELECTED_BORDER_COLOR);
            paintBorders = true;
        }
        if (paintBorders) {
            Dimension d = this.getSize();
            if (this.isPhenodata) {
                g.drawOval(0, 0, d.width - 1, d.height - 1);
            } else {
                g.drawRect(0, 0, d.width - 1, d.height - 1);
            }
        }
        g2.setStroke(previousStroke);
    }

    public boolean inHitRegion(Point2D pt) {
        if (this.isGroup) {
            return handle.contains(pt.getX(), pt.getY());
        }
        return false;
    }
}

