/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.data.GraphVertex;
import fi.csc.microarray.client.data.MicroarrayGraph;
import fi.csc.microarray.client.data.PositionChangeAnimator;
import fi.csc.microarray.databeans.DataItem;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

public abstract class AbstractGraphVertex
extends DefaultGraphCell {
    private MicroarrayGraph graph;

    public AbstractGraphVertex(int x, int y, DataItem data, MicroarrayGraph graph) {
        super((Object)data);
        this.graph = graph;
        this.setPosition(new Point(x, y));
    }

    public int getX() {
        return (int)this.getBounds().getX();
    }

    public int getY() {
        return (int)this.getBounds().getY();
    }

    public void setPosition(Point point) {
        Hashtable attrs = new Hashtable();
        GraphConstants.setBounds(attrs, (Rectangle2D)new Rectangle2D.Double(point.getX(), point.getY(), this.getDefaultWidth(), this.getDefaultHeight()));
        this.graph.getGraphLayoutCache().editCell((Object)this, attrs);
        this.graph.repaint();
    }

    public void setPositionAnimated(Point target) {
        new PositionChangeAnimator(this, new Point(this.getX(), this.getY()), target);
    }

    public Rectangle2D getBounds() {
        return GraphConstants.getBounds((Map)this.getAttributes());
    }

    public MicroarrayGraph getGraph() {
        return this.graph;
    }

    public abstract int getDefaultWidth();

    public abstract int getDefaultHeight();

    public abstract String toString();

    public abstract String getToolTipString();

    public abstract void addChildVertex(GraphVertex var1);

    public abstract boolean removeChildVertex(GraphVertex var1);
}

