/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpStatus;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.log.Log;
import org.mortbay.util.TypeUtil;

public class ErrorPageErrorHandler
extends ErrorHandler {
    protected ServletContext _servletContext;
    protected Map _errorPages;

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
        if (this._errorPages != null) {
            String old_error_page;
            Integer code;
            Class<Object> exClass;
            String error_page = null;
            if (ServletException.class.equals(exClass = (Class)request.getAttribute("javax.servlet.error.exception_type")) && (error_page = (String)this._errorPages.get(exClass.getName())) == null) {
                Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
                while (th instanceof ServletException) {
                    th = ((ServletException)th).getRootCause();
                }
                if (th != null) {
                    exClass = th.getClass();
                }
            }
            while (error_page == null && exClass != null) {
                error_page = (String)this._errorPages.get(exClass.getName());
                exClass = exClass.getSuperclass();
            }
            if (error_page == null && (code = (Integer)request.getAttribute("javax.servlet.error.status_code")) != null) {
                error_page = (String)this._errorPages.get(TypeUtil.toString(code));
            }
            if (!(error_page == null || (old_error_page = (String)request.getAttribute("org.mortbay.jetty.error_page")) != null && old_error_page.equals(error_page))) {
                request.setAttribute("org.mortbay.jetty.error_page", error_page);
                Dispatcher dispatcher = (Dispatcher)this._servletContext.getRequestDispatcher(error_page);
                try {
                    if (dispatcher != null) {
                        dispatcher.error(request, response);
                        return;
                    }
                    Log.warn("No error page " + error_page);
                }
                catch (ServletException e) {
                    Log.warn("EXCEPTION ", e);
                    return;
                }
            }
        }
        super.handle(target, request, response, dispatch);
    }

    public Map getErrorPages() {
        return this._errorPages;
    }

    public void setErrorPages(Map errorPages) {
        this._errorPages = errorPages;
    }

    public void addErrorPage(Class exception, String uri) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(exception.getName(), uri);
    }

    public void addErrorPage(int code, String uri) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(HttpStatus.CACHE.get(code).toString(), uri);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._servletContext = ContextHandler.getCurrentContext();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

