/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.BitTwiddling;
import fi.csc.microarray.util.SecureSessionPool;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SecureSessionPoolTest {
    @Test
    public void testBasicUsage() {
        SecureSessionPool ssp = new SecureSessionPool();
        SecureSessionPool.Session session = ssp.createSession();
        session.putParameter("yksi", 1);
        session.putParameter("kaksi", 2);
        String id = session.getID().toString();
        SecureSessionPool.Session reloadedSession = ssp.getSession(UUID.fromString(id));
        Assert.assertTrue((Integer)reloadedSession.getParameter("yksi") == 1);
        Assert.assertTrue((Integer)reloadedSession.getParameter("kaksi") == 2);
        ssp.removeSession(reloadedSession);
        Assert.assertTrue(ssp.getSession(reloadedSession.getID()) == null);
    }

    @Test
    public void testKeyRandomness() {
        SecureSessionPool ssp = new SecureSessionPool();
        int valCount = 1000;
        HashSet<Long> numbers = new HashSet<Long>();
        for (int i = 0; i < 1000; ++i) {
            UUID id = ssp.createSession().getID();
            long xorredValue = id.getLeastSignificantBits() ^ id.getMostSignificantBits();
            Assert.assertFalse(numbers.contains(xorredValue), "duplicate key generated");
            numbers.add(xorredValue);
        }
        int[] bitCounts = BitTwiddling.calculateBitFrequencies(numbers);
        long average = 500L;
        long allowedError = 100L;
        long allowedErrorInAvg = 10L;
        long sum = 0L;
        for (int i = 0; i < bitCounts.length; ++i) {
            int count = bitCounts[i];
            sum += (long)count;
            Assert.assertTrue((long)BigInteger.valueOf((long)count - 500L).abs().intValue() < 100L, "bit count too far from theoretical average: " + count);
        }
        Assert.assertTrue((long)BigInteger.valueOf(sum / 64L - 500L).abs().intValue() < 10L, "average too far from theoretical average");
    }
}

