/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FeatureTest {
    private DataManager manager;

    public FeatureTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        this.manager = new FSDataManager();
        ApplicationConstants.plugFeatures(this.manager);
    }

    @Test(groups={"smoke"})
    public void testEmbeddedBinary() throws IOException, MicroarrayException {
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        DataBean binAffyMicroarray = this.manager.createDataBean("bin_affy.cel", this.getClass().getResourceAsStream("/binary_affy_example.cel"));
        Assert.assertFalse(affyMicroarray.fetchFeature("/embedded-binary-content/").exists());
        Assert.assertTrue(binAffyMicroarray.fetchFeature("/embedded-binary-content/").exists());
    }

    @Test(groups={"smoke"})
    public void testModifiers() throws IOException, MicroarrayException {
        float f;
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        Feature feature = affyMicroarray.fetchFeature("log(/normalised-expression)");
        Assert.assertNotNull(feature.exists());
        float last = 1.0f;
        Iterator<Float> i$ = feature.asFloats().iterator();
        while (i$.hasNext()) {
            last = f = i$.next().floatValue();
        }
        i$ = feature.asFloats().iterator();
        while (i$.hasNext()) {
            last = f = i$.next().floatValue();
        }
        Assert.assertEquals(Float.valueOf(last), Float.valueOf(7.426265f));
    }

    @Test(groups={"smoke"})
    public void testFeatures() throws MicroarrayException, IOException {
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        for (String feature : new String[]{"/normalised-expression", "/column/MEAN"}) {
            Assert.assertNotNull(affyMicroarray.fetchFeature(feature).asFloats(), "error in " + feature);
            for (float f : affyMicroarray.fetchFeature(feature).asFloats()) {
                Assert.assertTrue((double)f > 0.0, "illegal value: " + f + " in " + feature);
            }
        }
        Assert.assertTrue(affyMicroarray.fetchFeature("/column/MEAN").asFloats().iterator().next().floatValue() == 190.0f);
        float last = 0.0f;
        Iterator<Float> i$ = affyMicroarray.fetchFeature("/column/MEAN").asFloats().iterator();
        while (i$.hasNext()) {
            float f;
            last = f = i$.next().floatValue();
        }
        Assert.assertTrue(last == 172.0f);
        Assert.assertTrue(VisualisationMethod.ARRAY_LAYOUT.isApplicableTo(affyMicroarray));
        DataBean somData = this.manager.createDataBean("som.tsv", this.getClass().getResourceAsStream("/som.tsv"));
        Assert.assertTrue(VisualisationMethod.SOM.isApplicableTo(somData));
        Table som = somData.fetchFeature("/clusters/som").asTable();
        Assert.assertNotNull(som);
        Assert.assertEquals(som.getCount(), 5);
        DataBean hcTree = this.manager.createDataBean("hs.txt", this.getClass().getResourceAsStream("/hc.txt"));
        DataBean hcHeatmap = this.manager.createDataBean("hc.tsv", this.getClass().getResourceAsStream("/hc-normalized.tsv"));
        hcTree.addLink(DataBean.Link.DERIVATION, hcHeatmap);
        Assert.assertTrue(VisualisationMethod.HIERARCHICAL.isApplicableTo(hcTree));
        Table heatmap = hcTree.fetchFeature("/clusters/hierarchical/heatmap").asTable();
        Assert.assertNotNull(heatmap);
        heatmap.nextRow();
        Assert.assertNotNull(heatmap.getValue(" "));
        String tree = hcTree.fetchFeature("/clusters/hierarchical/tree").asStrings().iterator().next();
        Assert.assertNotNull(tree);
    }
}

