/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.BasicFeature;
import fi.csc.microarray.databeans.features.FeatureFactory;
import fi.csc.microarray.databeans.features.Table;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantTableFeature
extends BasicFeature {
    private Map<String, Integer> columnMap = new LinkedHashMap<String, Integer>();
    private Object[][] values;

    public static ConstantTableFeature createSingleRowTable(DataBean bean, FeatureFactory factory, Map<String, String> singleRow) {
        String[] columns = singleRow.keySet().toArray(new String[0]);
        Object[][] values = new String[columns.length][1];
        int i = 0;
        for (String column : columns) {
            System.out.println(column + ": " + singleRow.get(column));
            values[i][0] = singleRow.get(column);
        }
        return new ConstantTableFeature(bean, factory, columns, values);
    }

    public ConstantTableFeature(DataBean bean, FeatureFactory factory, String[] columns, Object[][] values) {
        super(bean, factory);
        if (columns.length != values.length) {
            throw new IllegalArgumentException("columns and values do not match in size");
        }
        for (int i = 0; i < columns.length; ++i) {
            this.columnMap.put(columns[i], i);
        }
        this.values = values;
    }

    @Override
    public Table asTable() throws MicroarrayException {
        return new ConstantFloatTable(this.columnMap, this.values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConstantFloatTable
    implements Table {
        private int row = -1;
        private Map<String, Integer> columnMap;
        private Object[][] values;

        public ConstantFloatTable(Map<String, Integer> columnMap, Object[][] values) {
            this.columnMap = columnMap;
            this.values = values;
        }

        @Override
        public boolean nextRow() {
            ++this.row;
            return this.row < this.values[0].length;
        }

        @Override
        public String[] getColumnNames() {
            return this.columnMap.keySet().toArray(new String[0]);
        }

        @Override
        public float getFloatValue(String columnName) {
            return ((Float)this.getValue(columnName)).floatValue();
        }

        @Override
        public String getStringValue(String columnName) {
            return (String)this.getValue(columnName);
        }

        @Override
        public int getIntValue(String columnName) {
            return (Integer)this.getValue(columnName);
        }

        @Override
        public Object getValue(String columnName) {
            return this.values[this.columnMap.get(columnName)][this.row];
        }

        @Override
        public boolean hasColumn(String columnName) {
            return this.columnMap.get(columnName) != null;
        }

        @Override
        public int getCount() {
            return this.columnMap.keySet().size();
        }
    }
}

