/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationListModel;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.OverlayLayout;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ShapeUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scatterplot
extends Visualisation
implements ActionListener,
MouseListener,
MouseMotionListener {
    private ChartPanel chartPanel;
    private JPanel paramPanel;
    private JPanel settingsPanel;
    private JPanel overlayPanel;
    private AnnotateListPanel list;
    private VisualisationListModel xListModel;
    private JComboBox xBox;
    private VisualisationListModel yListModel;
    private JComboBox yBox;
    private JButton useButton;
    private Set<DataItem2D> allItems = new HashSet<DataItem2D>();
    private Set<String> selectedItemNames = new HashSet<String>();
    private TransparentPanel transparentPanel;
    private Point startCoords;
    private boolean isDragged = false;

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.paramPanel.setLayout(new BorderLayout());
            JPanel settings = this.createSettingsPanel();
            this.list = new AnnotateListPanel();
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Settings", settings);
            tabPane.addTab("Selected", this.list);
            this.paramPanel.add((Component)tabPane, "Center");
        }
        return this.paramPanel;
    }

    public JPanel createSettingsPanel() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.xListModel = new VisualisationListModel();
        this.xBox = new JComboBox(this.xListModel);
        this.yListModel = new VisualisationListModel();
        this.yBox = new JComboBox(this.yListModel);
        this.useButton = new JButton("Draw");
        this.useButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 10, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.settingsPanel.add((Component)new JLabel("X-axis: "), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.xBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)new JLabel("Y-axis: "), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.yBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.useButton, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.settingsPanel.add((Component)new JPanel(), c);
        this.xBox.addActionListener(this);
        this.yBox.addActionListener(this);
        return this.settingsPanel;
    }

    private void refreshAxisBoxes(DataBean data) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        this.xListModel.fillVariablesFor(data, VisualisationMethod.SCATTERPLOT);
        this.yListModel.fillVariablesFor(data, VisualisationMethod.SCATTERPLOT);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useButton) {
            this.refreshAxisBoxes(Session.getSession().getApplication().getSelectionManager().getSelectedDataBean());
            Session.getSession().getApplication().setVisualisationMethod(VisualisationMethod.SCATTERPLOT);
        }
    }

    @Override
    public JComponent getVisualisation(DataBean data, Dimension size) throws Exception {
        this.allItems.clear();
        this.selectedItemNames.clear();
        this.refreshAxisBoxes(data);
        Visualisation.Variable xVar = (Visualisation.Variable)this.xBox.getSelectedItem();
        Visualisation.Variable yVar = (Visualisation.Variable)this.yBox.getSelectedItem();
        Iterable<Float> xValues = data.fetchFeature(xVar.getExpression()).asFloats();
        Iterable<Float> yValues = data.fetchFeature(yVar.getExpression()).asFloats();
        LinkedList<String> names = new LinkedList<String>();
        for (String name : data.fetchFeature("/column/ ").asStrings()) {
            names.add(name);
        }
        Visualisation.PlotDescription description = new Visualisation.PlotDescription(data.getName(), xVar.getName(), yVar.getName());
        XYSeries series = this.toXYSeries(xValues, yValues, "");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        NumberAxis domainAxis = new NumberAxis(description.xTitle);
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis(description.yTitle);
        rangeAxis.setAutoRangeIncludesZero(false);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1);
        renderer.setShape(new Rectangle(-1, -1, 2, 2));
        PositionRecordingRenderer jeeJeeRenderer = new PositionRecordingRenderer(1, names);
        XYPlot plot = new XYPlot(dataset, domainAxis, rangeAxis, jeeJeeRenderer);
        JFreeChart chart = new JFreeChart(description.plotTitle, plot);
        this.chartPanel = this.makePanel(chart, size);
        this.chartPanel.addMouseListener(this);
        this.chartPanel.addMouseMotionListener(this);
        this.chartPanel.setMouseZoomable(false);
        this.overlayPanel = new JPanel(new OverlayLayout());
        this.transparentPanel = new TransparentPanel();
        this.overlayPanel.add(this.transparentPanel);
        this.overlayPanel.add(this.chartPanel);
        return this.overlayPanel;
    }

    private XYSeries toXYSeries(Iterable<Float> xValues, Iterable<Float> yValues, String name) {
        XYSeries series = new XYSeries((Comparable)((Object)name));
        Iterator<Float> xIterator = xValues != null ? xValues.iterator() : null;
        int i = 0;
        for (Float y : yValues) {
            if (xIterator != null) {
                series.add(xIterator.next(), (Number)y);
            } else {
                series.add((double)i, (Number)y);
            }
            ++i;
        }
        return series;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isControlDown()) {
            this.selectedItemNames.clear();
        }
        Rectangle2D r = null;
        for (DataItem2D item : this.allItems) {
            r = item.getBounds();
            if (!r.contains(e.getPoint())) continue;
            this.selectedItemNames.add(item.getName());
        }
        this.list.setSelectedListContentStrings(this.selectedItemNames);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startCoords = e.getPoint();
        this.isDragged = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.transparentPanel.setArea(null);
        this.transparentPanel.repaint();
        if (this.isDragged) {
            if (!e.isControlDown()) {
                this.selectedItemNames.clear();
            }
            Rectangle2D r = null;
            int x = (int)this.startCoords.getX() < e.getX() ? (int)this.startCoords.getX() : e.getX();
            int y = (int)this.startCoords.getY() < e.getY() ? (int)this.startCoords.getY() : e.getY();
            int w = Math.abs(e.getX() - (int)this.startCoords.getX());
            int h = Math.abs(e.getY() - (int)this.startCoords.getY());
            Rectangle selectedArea = new Rectangle(x, y, w, h);
            for (DataItem2D item : this.allItems) {
                r = item.getBounds();
                if (!selectedArea.intersects(r)) continue;
                this.selectedItemNames.add(item.getName());
            }
            this.list.setSelectedListContentStrings(this.selectedItemNames);
        }
        this.chartPanel.getChart().fireChartChanged();
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getVisualiser().canVisualise(bean);
        return isTabular && bean.fetchFeature("/column/chip.*").exists();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.isDragged = true;
        int x = (int)this.startCoords.getX() < e.getX() ? (int)this.startCoords.getX() : e.getX();
        int y = (int)this.startCoords.getY() < e.getY() ? (int)this.startCoords.getY() : e.getY();
        int w = Math.abs(e.getX() - (int)this.startCoords.getX());
        int h = Math.abs(e.getY() - (int)this.startCoords.getY());
        this.transparentPanel.setArea(new Rectangle(x, y, w, h));
        this.transparentPanel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private class TransparentPanel
    extends JPanel {
        private Rectangle2D area;

        public TransparentPanel() {
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            super.paintComponents(g);
            if (this.area != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.DARK_GRAY);
                g2d.setStroke(VisualConstants.dashLine);
                g2d.draw(this.area);
            }
        }

        private void setArea(Rectangle area) {
            this.area = area;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PositionRecordingRenderer
    extends StandardXYItemRenderer {
        private LinkedList<String> itemNames;

        public PositionRecordingRenderer(int shapes, LinkedList<String> names) {
            super(shapes);
            this.itemNames = names;
        }

        @Override
        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            Image image;
            boolean itemVisible = this.getItemVisible(series, item);
            Shape entityArea = null;
            EntityCollection entities = null;
            if (info != null) {
                entities = info.getOwner().getEntityCollection();
            }
            PlotOrientation orientation = plot.getOrientation();
            Paint paint = this.getItemPaint(series, item);
            Stroke seriesStroke = this.getItemStroke(series, item);
            g2.setPaint(paint);
            g2.setStroke(seriesStroke);
            double x1 = dataset.getXValue(series, item);
            double y1 = dataset.getYValue(series, item);
            if (Double.isNaN(x1) || Double.isNaN(y1)) {
                itemVisible = false;
            }
            RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
            double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
            double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
            if (this.getPlotLines()) {
                StandardXYItemRenderer.State s = (StandardXYItemRenderer.State)state;
                if (itemVisible && !Double.isNaN(transX1) && !Double.isNaN(transY1)) {
                    float x = (float)transX1;
                    float y = (float)transY1;
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        x = (float)transY1;
                        y = (float)transX1;
                    }
                    if (s.isLastPointGood()) {
                        s.seriesPath.lineTo(x, y);
                    } else {
                        s.seriesPath.moveTo(x, y);
                    }
                    s.setLastPointGood(true);
                } else {
                    s.setLastPointGood(false);
                }
                if (item == dataset.getItemCount(series) - 1) {
                    g2.setStroke(this.getSeriesStroke(series));
                    g2.setPaint(this.getSeriesPaint(series));
                    g2.draw(s.seriesPath);
                }
            }
            if (!itemVisible) {
                return;
            }
            if (this.getBaseShapesVisible()) {
                Shape shape = this.getItemShape(series, item);
                if (orientation == PlotOrientation.HORIZONTAL) {
                    shape = ShapeUtilities.createTranslatedShape(shape, transY1, transX1);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    shape = ShapeUtilities.createTranslatedShape(shape, transX1, transY1);
                }
                if (shape.intersects(dataArea)) {
                    if (this.getItemShapeFilled(series, item)) {
                        g2.fill(shape);
                    } else {
                        g2.draw(shape);
                    }
                    if (Scatterplot.this.selectedItemNames.contains(this.itemNames.get(item))) {
                        Rectangle rect = shape.getBounds();
                        rect.grow(2, 2);
                        g2.draw(rect);
                    }
                    Rectangle rect = new Rectangle();
                    rect.setSize(shape.getBounds().getSize());
                    rect.setLocation(Scatterplot.this.chartPanel.translateJava2DToScreen(shape.getBounds().getLocation()));
                    Scatterplot.this.allItems.add(new DataItem2D(rect, this.itemNames.get(item)));
                }
                entityArea = shape;
            }
            if (this.getPlotImages() && (image = this.getImage(plot, series, item, transX1, transY1)) != null) {
                Point hotspot = this.getImageHotspot(plot, series, item, transX1, transY1, image);
                g2.drawImage(image, (int)(transX1 - hotspot.getX()), (int)(transY1 - hotspot.getY()), null);
                entityArea = new Rectangle2D.Double(transX1 - hotspot.getX(), transY1 - hotspot.getY(), image.getWidth(null), image.getHeight(null));
            }
            if (this.isItemLabelVisible(series, item)) {
                double xx = transX1;
                double yy = transY1;
                if (orientation == PlotOrientation.HORIZONTAL) {
                    xx = transY1;
                    yy = transX1;
                }
                this.drawItemLabel(g2, orientation, dataset, series, item, xx, yy, y1 < 0.0);
            }
            if (entities != null) {
                this.addEntity(entities, entityArea, dataset, series, item, transX1, transY1);
            }
        }
    }

    private class DataItem2D {
        private Rectangle2D bounds;
        private String name;

        public DataItem2D(Rectangle2D r, String n) {
            this.bounds = r;
            this.name = n;
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public String getName() {
            return this.name;
        }
    }
}

