/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;

public class ExpressionProfile
extends Visualisation {
    public JComponent getVisualisation(DataBean data, Dimension size) throws Exception {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Table samples = data.fetchFeature("/column/*").asTable();
        while (samples.nextRow()) {
            for (String sample : samples.getColumnNames()) {
                if (!sample.startsWith("chip.")) continue;
                String sampleName = data.fetchFeature("/phenodata/linked/sample_to_name/" + sample.substring("chip.".length())).asString();
                dataset.addValue(samples.getFloatValue(sample), (Comparable)((Object)samples.getStringValue(" ")), (Comparable)((Object)sampleName));
            }
        }
        CategoryAxis categoryAxis = new CategoryAxis("sample");
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        NumberAxis valueAxis = new NumberAxis("expression");
        LineAndShapeRenderer renderer = new LineAndShapeRenderer(true, false);
        renderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, valueAxis, renderer);
        ProfileDrawingSupplier drawingSupplier = new ProfileDrawingSupplier();
        plot.setDrawingSupplier(drawingSupplier);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Expression profile for " + data.getName(), JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        return this.makePanel(chart, size);
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getVisualiser().canVisualise(bean);
        if (isTabular) {
            Table chips = bean.fetchFeature("/column/chip.*").asTable();
            return chips != null && chips.getColumnNames().length > 1;
        }
        return false;
    }

    static class ProfileDrawingSupplier
    extends DefaultDrawingSupplier {
        private static final Color LINE_COLOR = Color.BLUE.darker();

        ProfileDrawingSupplier() {
        }

        public Paint getNextPaint() {
            return LINE_COLOR;
        }
    }
}

