/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationPanel;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.util.ThreadUtils;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationTaskManager {
    private static final Logger logger = Logger.getLogger(VisualisationTaskManager.class);
    private LinkedList<Runnable> workQueue = new LinkedList();
    private Lock workQueueLock = new ReentrantLock();
    private Condition guiWorkAvailable = this.workQueueLock.newCondition();
    private ClientApplication application = Session.getSession().getApplication();
    private VisualisationPanel visualisationPanel;

    public VisualisationTaskManager(VisualisationPanel panel) {
        this.visualisationPanel = panel;
        Thread thread = ThreadUtils.getLowPriorityBackgroundThread(new GuiWorker());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visualise(List<DataBean> datas, VisualisationMethod method) {
        if (method != VisualisationMethod.NONE) {
            this.visualisationPanel.showWaitPanel();
            this.visualisationPanel.repaint();
        }
        this.workQueueLock.lock();
        try {
            this.workQueue.add(new VisualisationRunnable(datas, method));
            this.guiWorkAvailable.signalAll();
        }
        finally {
            this.workQueueLock.unlock();
        }
    }

    private class GuiWorker
    implements Runnable {
        private GuiWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!Thread.currentThread().isDaemon()) {
                throw new IllegalThreadStateException("GuiWorker must be run on daemon thread");
            }
            while (true) {
                Runnable visualisationRunnable = null;
                VisualisationTaskManager.this.workQueueLock.lock();
                try {
                    if (!VisualisationTaskManager.this.workQueue.isEmpty()) {
                        visualisationRunnable = (Runnable)VisualisationTaskManager.this.workQueue.getFirst();
                        VisualisationTaskManager.this.workQueue.clear();
                    }
                }
                finally {
                    VisualisationTaskManager.this.workQueueLock.unlock();
                }
                if (visualisationRunnable != null) {
                    visualisationRunnable.run();
                    continue;
                }
                VisualisationTaskManager.this.workQueueLock.lock();
                try {
                    VisualisationTaskManager.this.guiWorkAvailable.awaitUninterruptibly();
                    continue;
                }
                finally {
                    VisualisationTaskManager.this.workQueueLock.unlock();
                    continue;
                }
                break;
            }
        }
    }

    private class UpdateGuiRunnable
    implements Runnable {
        JPanel visualisation;

        public UpdateGuiRunnable(JPanel visualisation) {
            this.visualisation = visualisation;
        }

        public void run() {
            if (this.visualisation == null) {
                VisualisationTaskManager.this.visualisationPanel.showEmptyPanel();
            } else {
                VisualisationTaskManager.this.visualisationPanel.showVisualisationPanel(this.visualisation);
                if (logger.isDebugEnabled()) {
                    logger.debug("visualisation contains following components:");
                    for (Component component : this.visualisation.getComponents()) {
                        logger.debug("\t" + component);
                        if (!(component instanceof Container)) continue;
                        for (Component child : ((Container)component).getComponents()) {
                            logger.debug("\t\t" + child);
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VisualisationRunnable
    implements Runnable {
        private VisualisationMethod method;
        private List<DataBean> datas;

        public VisualisationRunnable(List<DataBean> datas, VisualisationMethod method) {
            this.method = method;
            this.datas = datas;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JPanel visualisation = this.method != null ? VisualisationTaskManager.this.visualisationPanel.createVisualisation(this.datas, this.method) : null;
                try {
                    SwingUtilities.invokeAndWait(new UpdateGuiRunnable(visualisation));
                }
                catch (InterruptedException e) {
                    VisualisationTaskManager.this.application.reportException(e);
                }
                catch (InvocationTargetException e) {
                    VisualisationTaskManager.this.application.reportException(e);
                }
                logger.debug("Duration, estimated: " + this.method.estimateDuration(this.datas) + "\treal: " + (System.currentTimeMillis() - startTime));
                if (logger.isInfoEnabled() && this.datas.size() > 0 && this.method != VisualisationMethod.NONE) {
                    long endTime = System.currentTimeMillis();
                    Table rowCounter = null;
                    rowCounter = this.datas.get(0).fetchFeature("/column/*").asTable();
                    int rowCount = 0;
                    while (rowCounter.nextRow()) {
                        ++rowCount;
                    }
                    logger.info("\tMethod\t" + (Object)((Object)this.method) + "\tDatas\t" + this.datas.size() + "\tRows\t" + rowCount + "\tByteLength\t" + this.datas.get(0).getContentLength() + "\tTime\t" + (endTime - startTime) + "\tTime/ByteLength\t" + (endTime - startTime) / this.datas.get(0).getContentLength() + "\t");
                }
            }
            catch (Exception me) {
                VisualisationTaskManager.this.application.reportException(me);
            }
        }
    }
}

