/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;

public class PercentageParameter
extends Parameter {
    private final int minValue;
    private final int maxValue;
    private int value;

    public PercentageParameter(String name, int initValue) throws IllegalArgumentException {
        this(name, name, 0, 100, initValue);
    }

    public PercentageParameter(String name, String description, int minValue, int maxValue, int initValue) throws IllegalArgumentException {
        super(name, description);
        if (minValue < 0) {
            throw new IllegalArgumentException("Minimum value for percentage parameter " + this.getName() + " cannot be less than zero.");
        }
        if (maxValue > 100) {
            throw new IllegalArgumentException("Maximum value for percentage parameter " + this.getName() + " cannot be over 100.");
        }
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new IllegalArgumentException("Minimum value for percentage parameter " + this.getName() + " cannot be bigger than the maximum value.");
        }
        this.maxValue = maxValue;
        this.setIntegerValue(initValue);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getIntegerValue() {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setIntegerValue(int newValue) {
        if (newValue < this.minValue || newValue > this.maxValue) {
            throw new IllegalArgumentException("Initial value for percentage parameter " + this.getName() + " must be within given limits.");
        }
        this.value = newValue;
    }

    public void setValue(Object newValue) {
        if (this.checkValidityOf(newValue)) {
            this.value = (Integer)newValue;
            return;
        }
        throw new IllegalArgumentException(newValue + " is an illegal " + "value for percentage parameter \"" + this.getName() + "\" (" + this.minValue + " ... " + this.maxValue + ")");
    }

    public boolean checkValidityOf(Object valueObject) {
        if (!(valueObject instanceof Integer)) {
            return false;
        }
        Integer intValue = (Integer)valueObject;
        return intValue >= this.minValue && intValue <= this.maxValue;
    }

    public String toString() {
        return this.getName() + ": " + this.value + "%";
    }

    public String getValueAsJava() {
        return "" + this.value;
    }
}

