/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.data.TreeKeyboardListener;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TreePanel
extends JPanel
implements DataChangeListener,
TreeSelectionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(TreePanel.class);
    private JTree tree = null;
    private DefaultTreeModel treeModel = null;
    private DefaultMutableTreeNode rootNode = null;
    private DataFolder rootFolder = null;
    private Map<DataItem, DefaultMutableTreeNode> nodeMap = new HashMap<DataItem, DefaultMutableTreeNode>();
    private ClientApplication application = Session.getSession().getApplication();
    private TreeKeyboardListener keyboardListener = new TreeKeyboardListener();
    private boolean disableSelectionReporting = false;

    public TreePanel(DataFolder rootFolder) {
        super(new GridBagLayout());
        this.rootFolder = rootFolder;
        this.tree = this.getTree();
        this.tree.setName("datasetTree");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(280, 250));
        JPanel dataTreePanel = new JPanel(new GridBagLayout());
        dataTreePanel.setBackground(this.tree.getBackground());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        c.gridy = 1;
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        dataTreePanel.add((Component)this.tree, c);
        JScrollPane scroller = new JScrollPane(dataTreePanel);
        scroller.setBorder(null);
        scroller.setMinimumSize(new Dimension(0, 0));
        this.add((Component)scroller, c);
        Session.getSession().getDataManager().addDataChangeListener(this);
        Session.getSession().getApplication().addPropertyChangeListener(this);
    }

    private JTree getTree() {
        if (this.tree == null) {
            this.rootNode = new DefaultMutableTreeNode(this.rootFolder);
            this.nodeMap.put(this.rootFolder, this.rootNode);
            this.treeModel = new DefaultTreeModel(this.rootNode);
            this.tree = new JTree(this.treeModel);
            this.tree.setCellRenderer(new CustomTreeCellRenderer());
            this.tree.addTreeSelectionListener(this);
            this.tree.addMouseListener(new TreeMouseListener());
            this.tree.addKeyListener(this.keyboardListener);
        }
        return this.tree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertData(DataItem data) {
        if (this.nodeMap.containsKey(data)) {
            throw new RuntimeException(data.getName() + " already exists in tree");
        }
        if (data.getParent() != null && !this.nodeMap.containsKey(data.getParent())) throw new RuntimeException("parent of " + data.getName() + " was not inserted (it is " + data.getParent().getName() + ")");
        if (data instanceof DataBean) {
            DefaultMutableTreeNode node = this.createNode(data);
            this.nodeMap.put(data, node);
            return;
        } else {
            if (!(data instanceof DataFolder)) throw new RuntimeException("illegal data type: " + data.getClass().getSimpleName());
            DataFolder folder = (DataFolder)data;
            if (folder.getParent() == null) {
                this.rootFolder.addChild(folder);
            }
            DefaultMutableTreeNode node = this.createNode(folder);
            this.nodeMap.put(folder, node);
            for (DataItem data1 : folder.getChildren()) {
                this.insertData(data1);
            }
        }
    }

    public void removeData(DataItem data) {
        DefaultMutableTreeNode node = this.nodeMap.get(data);
        if (node == null) {
            throw new RuntimeException(data.getName() + " does not exists in tree");
        }
        this.treeModel.removeNodeFromParent(node);
        TreeNode parent = node.getParent();
        this.treeModel.nodeStructureChanged(parent);
        this.nodeMap.remove(data);
        this.tree.repaint();
    }

    private DefaultMutableTreeNode createNode(DataItem data) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data);
        DataFolder parentFolder = data.getParent();
        DefaultMutableTreeNode parentNode = parentFolder != null ? this.nodeMap.get(parentFolder) : this.rootNode;
        assert (parentNode != null);
        this.treeModel.insertNodeInto(node, parentNode, parentNode.getChildCount());
        this.disableSelectionReporting = true;
        TreePath[] paths = this.tree.getSelectionPaths();
        this.treeModel.nodeStructureChanged(parentNode);
        this.tree.setSelectionPaths(paths);
        this.disableSelectionReporting = false;
        return node;
    }

    public void updateNameFor(DataItem data) {
        DefaultMutableTreeNode node = this.nodeMap.get(data);
        if (node != null) {
            this.treeModel.nodeStructureChanged(node);
        }
    }

    public void propertyChange(PropertyChangeEvent dataEvent) {
        logger.debug("got " + dataEvent.getClass().getSimpleName());
        if (dataEvent instanceof DatasetChoiceEvent && !(dataEvent.getSource() instanceof TreePanel)) {
            LinkedList<TreePath> paths = new LinkedList<TreePath>();
            for (DataBean bean : this.application.getSelectionManager().getSelectedDataBeans()) {
                paths.add(new TreePath(this.nodeMap.get(bean).getPath()));
            }
            this.tree.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        }
    }

    public void dataChanged(DataChangeEvent dataEvent) {
        logger.debug("got " + dataEvent.getClass().getSimpleName());
        if (dataEvent instanceof DataChangeEvent) {
            DataItem data = dataEvent.getDataItem();
            if (dataEvent instanceof DataItemCreatedEvent) {
                this.insertData(data);
            } else if (dataEvent instanceof DataItemRemovedEvent) {
                this.removeData(data);
            }
            this.tree.repaint();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (!this.disableSelectionReporting) {
            TreePath[] paths = e.getPaths();
            logger.debug("Path count in valueChanged: " + paths.length);
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                DataItem item = (DataItem)node.getUserObject();
                if (e.isAddedPath(i)) {
                    logger.debug("Selected item: " + item);
                    this.application.getSelectionManager().selectMultiple(item, this);
                    continue;
                }
                logger.debug("Deselected item: " + item);
                this.application.getSelectionManager().deselectMultiple(item, this);
            }
        }
    }

    private class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CustomTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DataItem element = (DataItem)node.getUserObject();
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            renderer.setIcon(TreePanel.this.application.getIconFor(element));
            renderer.setText(element.toString() + " ");
            return this;
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                DataItem selectedItem = this.getSelectedElementFrom(e);
                if (selectedItem instanceof DataBean) {
                    TreePanel.this.application.visualiseWithBestMethod();
                } else if (selectedItem instanceof DataFolder) {
                    DataFolder folder = (DataFolder)selectedItem;
                    TreePanel.this.application.getSelectionManager().clearAll(false, this);
                    for (DataItem item : folder.getChildren()) {
                        if (!(item instanceof DataBean)) continue;
                        TreePanel.this.application.getSelectionManager().selectMultiple((DataBean)item, this);
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                if (this.getSelectedElementFrom(e) instanceof DataFolder) {
                    TreePanel.this.application.showPopupMenuFor(e, this.getSelectedElementFrom(e));
                } else {
                    ArrayList<DataItem> items = new ArrayList<DataItem>();
                    for (DataBean bean : TreePanel.this.application.getSelectionManager().getSelectedDataBeans()) {
                        items.add(bean);
                    }
                    TreePanel.this.application.showPopupMenuFor(e, items);
                }
            }
        }

        private DataItem getSelectedElementFrom(MouseEvent e) {
            Object selectedUserObject;
            Object selectedNode;
            TreePath selectedPath = TreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
            TreePanel.this.tree.setSelectionPath(selectedPath);
            if (selectedPath != null && (selectedNode = selectedPath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (selectedUserObject = ((DefaultMutableTreeNode)selectedNode).getUserObject()) != null && selectedUserObject instanceof DataItem) {
                return (DataItem)selectedUserObject;
            }
            return null;
        }
    }
}

