/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.data.AbstractGraphVertex;
import fi.csc.microarray.client.data.GraphPanel;
import fi.csc.microarray.client.data.GraphVertex;
import fi.csc.microarray.client.data.GroupVertex;
import fi.csc.microarray.client.data.LayoutManager;
import fi.csc.microarray.client.data.PhenodataVertex;
import fi.csc.microarray.client.data.ScrollAnimator;
import fi.csc.microarray.client.data.SmartAutoscrollGraphUI;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.databeans.LinksChangedEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jgraph.JGraph;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroarrayGraph
extends JGraph
implements DataChangeListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MicroarrayGraph.class);
    private ClientApplication application = Session.getSession().getApplication();
    private Map<DataBean, GraphVertex> vertexMap = new HashMap<DataBean, GraphVertex>();
    private List<GraphVertex> roots = new ArrayList<GraphVertex>();
    private List<GroupVertex> groups = new ArrayList<GroupVertex>();
    private LayoutManager layoutManager = new LayoutManager(this);
    private GraphPanel graphPanel;
    private GraphModel model;

    public MicroarrayGraph(GraphModel model, GraphLayoutCache cache, BasicMarqueeHandler mh, GraphPanel graphPanel) {
        super(model, cache, mh);
        this.model = model;
        this.graphPanel = graphPanel;
        this.setBackground(Color.WHITE);
        ToolTipManager.sharedInstance().registerComponent(this);
        Session.getSession().getDataManager().addDataChangeListener(this);
        Session.getSession().getApplication().addPropertyChangeListener(this);
    }

    public void insertData(DataBean data) {
        GraphVertex vertex;
        if (this.vertexMap.containsKey(data)) {
            throw new RuntimeException(data.getName() + " was already present in the graph");
        }
        if (data.fetchFeature("/phenodata").exists()) {
            vertex = new PhenodataVertex(0, 0, data, this);
        } else if (data.getLinkTargets(DataBean.Link.DERIVATION).size() == 0) {
            vertex = new GraphVertex(0, 0, data, this);
            this.roots.add(vertex);
        } else {
            vertex = new GraphVertex(10, 10, data, this);
        }
        for (DataBean targetBean : data.getLinkTargets(DataBean.Link.DERIVATION)) {
            GraphVertex parent = this.vertexMap.get(targetBean);
            if (vertex instanceof PhenodataVertex) continue;
            DefaultPort parentPort = new DefaultPort();
            parent.add(parentPort);
            parentPort.setParent(parent);
            DefaultPort childPort = new DefaultPort();
            vertex.add(childPort);
            childPort.setParent(vertex);
            parent.addChildVertex(vertex);
            this.insertLink(vertex, parent, DataBean.Link.DERIVATION);
        }
        this.vertexMap.put(data, vertex);
        this.getGraphLayoutCache().insert(vertex);
        this.layoutManager.updateLayout(vertex);
        this.scrollCellToVisibleAnimated(vertex);
        this.repaint();
    }

    public void removeData(DataBean data) {
        GroupVertex group;
        GraphVertex vertex = this.vertexMap.get(data);
        if (vertex == null) {
            throw new IllegalArgumentException(data.getName() + " was not present in graph");
        }
        Vector<DefaultGraphCell> removedCells = new Vector<DefaultGraphCell>();
        removedCells.add(vertex);
        List children = vertex.getChildren();
        for (Object e : children) {
            if (!(e instanceof DefaultPort)) continue;
            DefaultPort port = (DefaultPort)e;
            Set edges = port.getEdges();
            for (Object edgeObject : edges) {
                if (!(edgeObject instanceof DefaultEdge)) continue;
                DefaultEdge edge = (DefaultEdge)edgeObject;
                Object source = edge.getSource();
                if (source instanceof DefaultPort) {
                    DefaultPort sourcePort = (DefaultPort)source;
                    removedCells.add(sourcePort);
                }
                removedCells.add(edge);
            }
            removedCells.add(port);
        }
        if (vertex.getGroup() != null && (group = vertex.getGroup()).getChildCount() - 2 < 1) {
            removedCells.add(group);
        }
        this.getGraphLayoutCache().remove(removedCells.toArray());
        this.model.remove(removedCells.toArray());
        this.vertexMap.remove(data);
        for (Object e : removedCells) {
            TreeNode parent;
            if (this.roots.contains(e)) {
                this.roots.remove(e);
                continue;
            }
            if (this.groups.contains(e)) {
                this.groups.remove(e);
                continue;
            }
            if (!(e instanceof AbstractGraphVertex) || (parent = ((AbstractGraphVertex)e).getParent()) == null || !(parent instanceof GraphVertex)) continue;
            ((GraphVertex)parent).removeChildVertex((GraphVertex)e);
        }
        this.repaint();
    }

    public void createGroup(DataBean data) {
        GraphVertex groupMember = this.vertexMap.get(data);
        this.createGroup(new GraphVertex[]{groupMember});
    }

    private GroupVertex createGroup(GraphVertex[] children) {
        if (children.length < 1) {
            throw new IllegalArgumentException("vertex list is empty");
        }
        Rectangle2D bounds = this.getCellBounds(children);
        GroupVertex group = new GroupVertex((int)bounds.getX(), (int)bounds.getY(), children, this);
        this.getGraphLayoutCache().insertGroup(group, children);
        if (GroupVertex.DEFAULT_COLLAPSED_STATE_WHEN_CREATED) {
            group.collapse();
        }
        this.groups.add(group);
        return group;
    }

    public void scrollCellToVisibleAnimated(GraphVertex cell) {
        if (cell != null) {
            new ScrollAnimator(this.graphPanel, cell.getBounds().getBounds());
        }
    }

    public void updateSelectedCells() {
        ArrayList<GraphVertex> selectedCells = new ArrayList<GraphVertex>();
        for (DataBean selected : this.application.getSelectionManager().getSelectedDatasAsArray()) {
            selectedCells.add(this.getVertexMap().get(selected));
        }
        this.setSelectionCells(selectedCells.toArray());
        for (GroupVertex group : this.groups) {
            if (group.isAllChildrenSelected()) {
                this.addSelectionCell(group);
                continue;
            }
            this.removeSelectionCell(group);
        }
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Object cell = this.getFirstCellForLocation(event.getX(), event.getY());
        if (cell instanceof GraphVertex) {
            return ((GraphVertex)cell).getToolTipString();
        }
        return null;
    }

    public List<GraphVertex> getRootVertexes() {
        return this.roots;
    }

    public Map<DataBean, GraphVertex> getVertexMap() {
        return this.vertexMap;
    }

    public List<AbstractGraphVertex> getAllVertexes() {
        ArrayList<AbstractGraphVertex> vertexes = new ArrayList<AbstractGraphVertex>();
        for (DataBean data : this.application.getAllDataBeans()) {
            GraphVertex vertex = this.vertexMap.get(data);
            if (vertex == null) continue;
            vertexes.add(vertex);
        }
        return vertexes;
    }

    public List<AbstractGraphVertex> getVisibleVertexes() {
        CellView[] views = this.getGraphLayoutCache().getCellViews();
        ArrayList<AbstractGraphVertex> vertexes = new ArrayList<AbstractGraphVertex>();
        for (CellView view : views) {
            if (view == null || !(view.getCell() instanceof AbstractGraphVertex)) continue;
            AbstractGraphVertex vertex = (AbstractGraphVertex)view.getCell();
            vertexes.add(vertex);
        }
        return vertexes;
    }

    public List<AbstractGraphVertex> getVertexesAtPoint(Point2D point) {
        int x = (int)point.getX();
        int y = (int)point.getY();
        ArrayList<AbstractGraphVertex> vertexes = new ArrayList<AbstractGraphVertex>();
        Object temporaryTopmost = this.getFirstCellForLocation(x, y);
        if (!(temporaryTopmost instanceof AbstractGraphVertex)) {
            return null;
        }
        AbstractGraphVertex topmost = (AbstractGraphVertex)temporaryTopmost;
        vertexes.add(topmost);
        Object current = topmost;
        do {
            if ((current = this.getNextCellForLocation(current, x, y)) == topmost || !(current instanceof AbstractGraphVertex)) continue;
            vertexes.add((AbstractGraphVertex)current);
        } while (current != topmost);
        return vertexes;
    }

    public Dimension getGraphSize() {
        Dimension dim = new Dimension(0, 0);
        for (AbstractGraphVertex vertex : this.getAllVertexes()) {
            int x = vertex.getX();
            int y = vertex.getY();
            if ((double)x > dim.getWidth()) {
                dim.width = x;
            }
            if (!((double)y > dim.getHeight())) continue;
            dim.height = y;
        }
        dim.width += 70;
        dim.height += 50;
        return dim;
    }

    public Dimension fromScreenCoordinates(Dimension dim) {
        Point2D fromScreen = this.fromScreen(new Point2D.Double(dim.getWidth(), dim.getHeight()));
        return new Dimension((int)fromScreen.getX(), (int)fromScreen.getY());
    }

    @Override
    public Object getFirstCellForLocation(double x, double y) {
        Object cell = super.getFirstCellForLocation(x, y);
        Point p = new Point((int)x, (int)y);
        Object vertex = cell instanceof GroupVertex ? (((GroupVertex)cell).isInCollapseHandleHitRegion(p, this) ? null : (((GroupVertex)cell).isCollapsed() ? (GroupVertex)cell : ((cell = super.getNextCellForLocation(cell, x, y)) instanceof GraphVertex ? (GraphVertex)cell : null))) : (cell instanceof GraphVertex ? (GraphVertex)cell : null);
        return vertex;
    }

    @Override
    public void updateUI() {
        this.setUI(new SmartAutoscrollGraphUI());
        this.invalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event instanceof DatasetChoiceEvent) {
            this.updateSelectedCells();
        }
    }

    @Override
    public void dataChanged(DataChangeEvent event) {
        DataItem data;
        if (event instanceof ContentChangedEvent) {
            this.repaint();
        } else if (event instanceof LinksChangedEvent) {
            LinksChangedEvent lcEvent = (LinksChangedEvent)event;
            if (lcEvent.isCreation()) {
                this.insertLink(lcEvent.getSource(), lcEvent.getTarget(), lcEvent.getType());
            } else {
                this.removeLink(lcEvent.getSource(), lcEvent.getTarget(), lcEvent.getType());
            }
        } else if (event instanceof DataChangeEvent && (data = event.getDataItem()) instanceof DataBean) {
            if (event instanceof DataItemCreatedEvent) {
                this.insertData((DataBean)data);
            } else if (event instanceof DataItemRemovedEvent) {
                this.removeData((DataBean)data);
            }
            this.repaint();
        }
    }

    private void moveCloseToAnnotated(DataBean data) {
        DataBean annotatedBean;
        List<DataBean> list = data.getLinkTargets(DataBean.Link.ANNOTATION);
        DataBean dataBean = annotatedBean = list.size() > 0 ? list.get(0) : null;
        if (annotatedBean == null) {
            throw new IllegalArgumentException(data.getName() + " must have ANNOTATION link target(s)");
        }
        GraphVertex vertex = this.vertexMap.get(data);
        Rectangle2D bounds = this.vertexMap.get(annotatedBean).getBounds();
        vertex.setPosition(new Point((int)bounds.getX() + 40 + 30, (int)bounds.getY()));
    }

    private static void setDerivationEgdeStyle(DefaultEdge edge) {
        GraphConstants.setLineBegin(edge.getAttributes(), 2);
        GraphConstants.setBeginFill(edge.getAttributes(), true);
        GraphConstants.setBeginSize(edge.getAttributes(), 5);
        GraphConstants.setLineWidth(edge.getAttributes(), 1.0f);
        GraphConstants.setSelectable(edge.getAttributes(), false);
    }

    private static void setAnnotationEdgeStyle(DefaultEdge edge) {
        GraphConstants.setSelectable(edge.getAttributes(), false);
        GraphConstants.setForeground(edge.getAttributes(), Color.LIGHT_GRAY);
        GraphConstants.setDashPattern(edge.getAttributes(), new float[]{2.0f, 2.0f});
    }

    public void insertLink(DataBean source, DataBean target, DataBean.Link type) {
        logger.debug("adding link (" + (Object)((Object)type) + ") from " + source.getName() + " to " + target.getName());
        GraphVertex sourceVertex = this.vertexMap.get(source);
        GraphVertex targetVertex = this.vertexMap.get(target);
        if (sourceVertex == null || targetVertex == null) {
            throw new RuntimeException("source or target vertex not found: source " + sourceVertex + ", target " + targetVertex);
        }
        this.insertLink(sourceVertex, targetVertex, type);
    }

    private void insertLink(GraphVertex sourceVertex, GraphVertex targetVertex, DataBean.Link type) {
        if (type.equals((Object)DataBean.Link.GROUPING)) {
            if (sourceVertex.getGroup() != null && targetVertex.getGroup() != null) {
                if (sourceVertex.getGroup() == targetVertex.getGroup()) {
                    return;
                }
                throw new IllegalArgumentException("beans already have different groups");
            }
            if (sourceVertex.getGroup() == null && targetVertex.getGroup() == null) {
                this.createGroup(sourceVertex.getData());
            }
            if (sourceVertex.getGroup() != null) {
                sourceVertex.getGroup().addChildVertex(targetVertex);
            } else {
                targetVertex.getGroup().addChildVertex(sourceVertex);
            }
        } else if (type.equals((Object)DataBean.Link.ANNOTATION) || type.equals((Object)DataBean.Link.DERIVATION)) {
            NoLabelEdge linkEdge = new NoLabelEdge((Object)type);
            linkEdge.setSource(sourceVertex.getChildAt(0));
            linkEdge.setTarget(targetVertex.getChildAt(0));
            if (type.equals((Object)DataBean.Link.ANNOTATION)) {
                MicroarrayGraph.setAnnotationEdgeStyle(linkEdge);
            } else {
                MicroarrayGraph.setDerivationEgdeStyle(linkEdge);
            }
            this.getGraphLayoutCache().insert(linkEdge);
            if (type.equals((Object)DataBean.Link.DERIVATION)) {
                this.layoutManager.updateLayout(sourceVertex);
            } else if (type.equals((Object)DataBean.Link.ANNOTATION)) {
                this.moveCloseToAnnotated(sourceVertex.getData());
            }
        } else {
            throw new IllegalArgumentException("unsupported link type: " + (Object)((Object)type));
        }
    }

    public void removeLink(DataBean source, DataBean target, DataBean.Link type) {
        GraphVertex sourceVertex = this.vertexMap.get(source);
        GraphVertex targetVertex = this.vertexMap.get(target);
        if (type.equals((Object)DataBean.Link.GROUPING)) {
            sourceVertex.getGroup().removeChildVertex(sourceVertex);
            this.createGroup(new GraphVertex[]{sourceVertex});
        } else {
            for (DefaultEdge edge : MicroarrayGraph.getAllEdgesOfVertex(sourceVertex, this)) {
                DataBean.Link edgeType = (DataBean.Link)((Object)edge.getUserObject());
                GraphVertex edgeSource = (GraphVertex)((DefaultPort)edge.getSource()).getParent();
                GraphVertex edgeTarget = (GraphVertex)((DefaultPort)edge.getTarget()).getParent();
                logger.debug("Edge type: " + (Object)((Object)edgeType) + ", edgeSource: " + edgeSource + ", edgeTarget: " + edgeTarget);
                if (!edgeSource.equals(sourceVertex) || !edgeTarget.equals(targetVertex) || !edgeType.equals((Object)type)) continue;
                this.graphLayoutCache.remove(new Object[]{edge});
            }
        }
    }

    private static List<DefaultEdge> getAllEdgesOfVertex(GraphVertex sourceVertex, JGraph graph) {
        GraphLayoutCache layoutCache = graph.getGraphLayoutCache();
        ArrayList<DefaultEdge> allEdges = new ArrayList<DefaultEdge>();
        for (Object edge : layoutCache.getOutgoingEdges(sourceVertex, null, false, false)) {
            if (!(edge instanceof DefaultEdge)) continue;
            allEdges.add((DefaultEdge)edge);
        }
        for (Object edge : layoutCache.getIncomingEdges(sourceVertex, null, false, false)) {
            if (!(edge instanceof DefaultEdge)) continue;
            allEdges.add((DefaultEdge)edge);
        }
        return allEdges;
    }

    private class NoLabelEdge
    extends DefaultEdge {
        public NoLabelEdge(Object userObject) {
            super(userObject);
        }

        public String toString() {
            return "";
        }
    }
}

