/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import com.jgoodies.looks.HeaderStyle;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.ToolBarComponentFactory;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.data.AbstractGraphVertex;
import fi.csc.microarray.client.data.GraphFoldingManager;
import fi.csc.microarray.client.data.GraphKeyboardListener;
import fi.csc.microarray.client.data.GraphRenderer;
import fi.csc.microarray.client.data.GraphVertex;
import fi.csc.microarray.client.data.GroupVertex;
import fi.csc.microarray.client.data.MicroarrayGraph;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.data.tools.HandTool;
import fi.csc.microarray.client.data.tools.SelectionTool;
import fi.csc.microarray.client.data.tools.Tools;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;

public class GraphPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public final float ZOOM_FACTOR = 1.2f;
    public final float ZOOM_IN_LIMIT = 1.5f;
    public final float ZOOM_OUT_LIMIT = 0.5f;
    private MicroarrayGraph graph = null;
    private SelectionTool selectionTool;
    private HandTool handTool;
    private ClientApplication application = Session.getSession().getApplication();
    private GraphModel model = new DefaultGraphModel();
    private JScrollPane graphScroller = null;
    private Tools selectedTool;
    private JToolBar buttonToolBar = null;
    private JToggleButton selectToolButton;
    private JToggleButton handToolButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JButton showAllButton;
    private JButton viewHistoryButton;
    private static final Logger logger = Logger.getLogger(GraphPanel.class);
    private Point center;

    public GraphPanel() {
        this.selectionTool = new SelectionTool(this.getGraph());
        this.handTool = new HandTool(this);
        this.getGraph().setMarqueeHandler(this.selectionTool);
        this.getGraph().addMouseListener(this.selectionTool);
        this.getGraph().addMouseListener(this.handTool);
        this.getGraph().addMouseMotionListener(this.handTool);
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(280, 240));
        this.buttonToolBar = this.getButtonToolBar();
        this.graphScroller = this.getGraphScroller();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 15;
        c.gridy = 1;
        this.add((Component)this.buttonToolBar, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.graphScroller, c);
        Session.getSession().getApplication().addPropertyChangeListener(this);
        this.graph.setCursor(Cursor.getPredefinedCursor(0));
        VertexView.renderer = new GraphRenderer();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        DataBean data = this.application.getSelectionManager().getSelectedDataBean();
        if (source == this.viewHistoryButton) {
            if (data != null) {
                this.application.showHistoryScreenFor(data);
            }
        } else if (source == this.selectToolButton) {
            this.deselectOtherButtons(source);
            this.selectedTool = Tools.SELECT;
            this.graph.setMarqueeHandler(this.selectionTool);
            this.graph.setEnabled(true);
            this.getScroller().setAutoscrolls(true);
            this.getScroller().setCursor(Cursor.getDefaultCursor());
        } else if (source == this.handToolButton) {
            this.deselectOtherButtons(source);
            this.selectedTool = Tools.HAND;
            this.graph.setMarqueeHandler(null);
            this.graph.setEnabled(false);
            this.getScroller().setAutoscrolls(false);
            this.getScroller().setCursor(Cursor.getPredefinedCursor(12));
        } else if (source == this.zoomInButton) {
            this.zoomInToolUsed();
        } else if (source == this.zoomOutButton) {
            this.zoomOutToolUsed();
        } else if (source == this.showAllButton) {
            double yScale;
            Dimension dim = this.graph.getGraphSize();
            double xScale = this.graphScroller.getSize().getWidth() / (double)dim.width;
            if (xScale < (yScale = this.graphScroller.getSize().getHeight() / (double)dim.height)) {
                this.setGraphScale(xScale);
            } else {
                this.setGraphScale(yScale);
            }
            logger.debug("Graph size: " + dim.width + " , " + dim.height + " Scroller size: " + this.graphScroller.getSize().getWidth() + " , " + this.graphScroller.getSize().getHeight() + " Scales: " + xScale + " , " + yScale);
        }
    }

    public Tools getSelectedTool() {
        return this.selectedTool;
    }

    public MicroarrayGraph getGraph() {
        if (this.graph == null) {
            DefaultCellViewFactory factory = new DefaultCellViewFactory();
            boolean partial = true;
            GraphLayoutCache cache = new GraphLayoutCache(this.model, factory, partial);
            this.graph = new MicroarrayGraph(this.model, cache, null, this);
            this.graph.addMouseListener(new GraphFoldingManager(this));
            this.graph.addKeyListener(new GraphKeyboardListener());
            this.graph.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        GraphPanel.this.showPopupMenu(e);
                    }
                }
            });
            this.graph.setAntiAliased(true);
            this.graph.setBendable(false);
            this.graph.setConnectable(false);
            this.graph.setDisconnectable(false);
            this.graph.setEditable(false);
            this.graph.setMoveable(true);
            this.graph.setPortsVisible(false);
            this.graph.setSizeable(false);
            this.graph.setGridColor(Color.LIGHT_GRAY);
            this.graph.setGridSize(10.0);
            this.graph.setGridVisible(true);
            this.graph.setGridEnabled(true);
        }
        return this.graph;
    }

    protected GraphModel getGraphModel() {
        return this.model;
    }

    protected void setHistoryButtonEnabled(boolean enabled) {
        this.viewHistoryButton.setEnabled(enabled);
    }

    private JScrollPane getGraphScroller() {
        if (this.graphScroller == null) {
            this.graphScroller = new JScrollPane(this.getGraph());
            this.graphScroller.setBorder(null);
            this.graphScroller.setMinimumSize(new Dimension(0, 0));
            ScrollListener scrollListener = new ScrollListener();
            this.graphScroller.getHorizontalScrollBar().addAdjustmentListener(scrollListener);
            this.graphScroller.getVerticalScrollBar().addAdjustmentListener(scrollListener);
        }
        return this.graphScroller;
    }

    public JToolBar getButtonToolBar() {
        if (this.buttonToolBar == null) {
            this.selectToolButton = ToolBarComponentFactory.createToggleButton(false, false);
            this.initialiseToolBarButton(this.selectToolButton);
            this.selectToolButton.setToolTipText("Select datasets");
            this.selectToolButton.setIcon(VisualConstants.ARROW_ICON);
            this.handToolButton = ToolBarComponentFactory.createToggleButton(false, false);
            this.handToolButton.setToolTipText("Move workflow diagram");
            this.initialiseToolBarButton(this.handToolButton);
            this.handToolButton.setIcon(VisualConstants.HAND_ICON);
            this.zoomInButton = ToolBarComponentFactory.createButton(false, false);
            this.zoomInButton.setToolTipText("Zoom in");
            this.initialiseToolBarButton(this.zoomInButton);
            this.zoomInButton.setIcon(VisualConstants.ZOOM_IN_ICON);
            this.zoomOutButton = ToolBarComponentFactory.createButton(false, false);
            this.zoomOutButton.setToolTipText("Zoom out");
            this.initialiseToolBarButton(this.zoomOutButton);
            this.zoomOutButton.setIcon(VisualConstants.ZOOM_OUT_ICON);
            this.viewHistoryButton = ToolBarComponentFactory.createButton(false, false);
            this.viewHistoryButton.setToolTipText("View History as Text");
            this.initialiseToolBarButton(this.viewHistoryButton);
            this.viewHistoryButton.setIcon(VisualConstants.GENERATE_HISTORY_ICON);
            this.viewHistoryButton.setEnabled(false);
            this.showAllButton = ToolBarComponentFactory.createButton(false, false);
            this.showAllButton.setToolTipText("Scale workflow to show all datasets");
            this.initialiseToolBarButton(this.showAllButton);
            this.showAllButton.setIcon(VisualConstants.SHOW_ALL_ICON);
            this.buttonToolBar = new JToolBar();
            this.buttonToolBar.setFloatable(false);
            this.buttonToolBar.setMinimumSize(new Dimension(0, 0));
            this.buttonToolBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
            this.selectedTool = Tools.SELECT;
            this.selectToolButton.setSelected(true);
            this.buttonToolBar.add(this.selectToolButton);
            this.buttonToolBar.add(this.handToolButton);
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(this.zoomInButton);
            this.buttonToolBar.add(this.zoomOutButton);
            this.buttonToolBar.add(this.showAllButton);
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(this.viewHistoryButton);
            this.buttonToolBar.addSeparator();
        }
        return this.buttonToolBar;
    }

    private void initialiseToolBarButton(AbstractButton button) {
        button.addActionListener(this);
        button.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    private void deselectOtherButtons(Object clicked) {
        this.selectToolButton.setSelected(clicked == this.selectToolButton);
        this.handToolButton.setSelected(clicked == this.handToolButton);
    }

    public void pointToCenter(Point2D target) {
        Point newViewPos = new Point();
        newViewPos.x = (int)(target.getX() - (double)this.graphScroller.getViewport().getWidth() / 2.0);
        newViewPos.y = (int)(target.getY() - (double)this.graphScroller.getViewport().getHeight() / 2.0);
        this.setViewPosition(newViewPos);
    }

    public void setViewPosition(Point2D p) {
        JScrollPane scroller = this.getScroller();
        double newX = p.getX();
        double newY = p.getY();
        int graphW = this.graph.getWidth();
        int graphH = this.graph.getHeight();
        int viewW = scroller.getViewport().getWidth();
        int viewH = scroller.getViewport().getHeight();
        int xLimit = graphW - viewW;
        int yLimit = graphH - viewH;
        if (newX > (double)xLimit) {
            newX = xLimit;
        }
        if (newY > (double)yLimit) {
            newY = yLimit;
        }
        if (newX < 0.0) {
            newX = 0.0;
        }
        if (newY < 0.0) {
            newY = 0.0;
        }
        scroller.getViewport().setViewPosition(new Point((int)newX, (int)newY));
        this.graph.repaint();
    }

    public JScrollPane getScroller() {
        return this.graphScroller;
    }

    public boolean setGraphScale(double scale) {
        double newScale = scale;
        if (scale > 1.5) {
            newScale = 1.5;
            this.zoomInButton.setEnabled(false);
        } else {
            this.zoomInButton.setEnabled(true);
        }
        if (scale < 0.5) {
            newScale = 0.5;
            this.zoomOutButton.setEnabled(false);
        } else {
            this.zoomOutButton.setEnabled(true);
        }
        this.graph.setScale(newScale);
        this.graphScroller.repaint();
        return newScale == scale;
    }

    private void showPopupMenu(MouseEvent e) {
        List<AbstractGraphVertex> chosenCells = this.graph.getVertexesAtPoint(e.getPoint());
        if (chosenCells != null && chosenCells.size() > 0) {
            for (AbstractGraphVertex vertex : chosenCells) {
                if (vertex instanceof GraphVertex) {
                    ArrayList<DataItem> items = new ArrayList<DataItem>();
                    for (DataBean bean : this.application.getSelectionManager().getSelectedDataBeans()) {
                        items.add(bean);
                    }
                    this.application.showPopupMenuFor(e, items);
                    continue;
                }
                if (!(vertex instanceof GroupVertex)) continue;
            }
        } else {
            DataItem nullBean = null;
            this.application.showPopupMenuFor(e, nullBean);
        }
    }

    private void zoomInToolUsed() {
        double d = this.graph.getScale();
        this.getClass();
        if (this.setGraphScale(d * (double)1.2f)) {
            JViewport view = this.getScroller().getViewport();
            Point viewPos = view.getViewPosition();
            this.center = new Point((int)(viewPos.getX() + (double)(view.getWidth() / 2)), (int)(viewPos.getY() + (double)(view.getHeight() / 2)));
            logger.debug("view.getX: " + view.getX() + ", viewWidth: " + view.getWidth());
            double d2 = this.center.getX();
            this.getClass();
            this.center.x = (int)(d2 * (double)1.2f);
            double d3 = this.center.getY();
            this.getClass();
            this.center.y = (int)(d3 * (double)1.2f);
            Thread centerer = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    GraphPanel.this.pointToCenter(GraphPanel.this.center);
                }
            };
            this.pointToCenter(this.center);
            SwingUtilities.invokeLater(centerer);
        }
        this.graph.repaint();
    }

    private void zoomOutToolUsed() {
        double d = this.graph.getScale();
        this.getClass();
        if (this.setGraphScale(d / (double)1.2f)) {
            JViewport view = this.getScroller().getViewport();
            Point viewPos = view.getViewPosition();
            this.center = new Point((int)(viewPos.getX() + (double)(view.getWidth() / 2)), (int)(viewPos.getY() + (double)(view.getHeight() / 2)));
            double d2 = this.center.getX();
            this.getClass();
            this.center.x = (int)(d2 / (double)1.2f);
            double d3 = this.center.getY();
            this.getClass();
            this.center.y = (int)(d3 / (double)1.2f);
            this.pointToCenter(this.center);
        }
        this.repaint();
        this.getScroller().repaint();
        this.graph.repaint();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e instanceof DatasetChoiceEvent) {
            if (this.application.getSelectionManager().getSelectedDataBean() != null && this.application.getSelectionManager().getSelectedDataBeans().size() == 1) {
                this.viewHistoryButton.setEnabled(true);
            } else {
                this.viewHistoryButton.setEnabled(false);
            }
            if (this.application.getSelectionManager().getSelectedDataBean() != null) {
                DataBean bean = this.application.getSelectionManager().getSelectedDataBean();
                this.graph.scrollCellToVisibleAnimated(this.graph.getVertexMap().get(bean));
            }
        } else {
            return;
        }
        this.graph.repaint();
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            GraphPanel.this.getGraph().repaint();
        }
    }
}

