/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.DemoAuthenticationRequestListener;
import fi.csc.microarray.client.ClientListener;
import fi.csc.microarray.client.SwingClientApplication;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import org.testng.Assert;

public class ClientTestHelper {
    public void runTest(final TestImplementation implementation) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        SwingClientApplication.start(new ClientListener(){

            public void onSuccessfulInitialisation() {
                try {
                    implementation.implementGUITest(new ShutdownCallback(){

                        public void closeNow() {
                            latch.countDown();
                        }

                        public void closeIn(int seconds) {
                            Timer timer = new Timer();
                            timer.schedule(new TimerTask(){

                                public void run() {
                                    latch.countDown();
                                }
                            }, seconds * 1000);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail(e.getMessage());
                }
            }

            public void onFailedInitialisation() {
                Assert.fail("GUI initialisation failed");
            }
        }, new DemoAuthenticationRequestListener());
        latch.await();
    }

    public static interface ShutdownCallback {
        public void closeNow();

        public void closeIn(int var1);
    }

    public static interface TestImplementation {
        public void implementGUITest(ShutdownCallback var1) throws Exception;
    }
}

