/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.analyser.AnalysisTestBase;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.fs.FSDataBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mortbay.util.IO;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BasicRAnalysisTest
extends AnalysisTestBase {
    @Test(groups={"smoke"})
    public void testRNoOperation() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"No-op\"");
        this.executeJob(job);
    }

    @Test(groups={"smoke"})
    public void testREcho() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"Echo\"");
        String input = "Haloo!";
        job.addParameter("echoParameter", input);
        this.executeJob(job);
        System.out.println("Output: " + job.getScreenOutput());
        Assert.assertTrue(job.getScreenOutput().contains("[1] \"" + input + "\""));
    }

    @Test(groups={"smoke"})
    public void testFailing() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"Fail\"");
        this.executeJob(job, Task.State.FAILED);
        Assert.assertTrue(job.getScreenOutput() != null);
    }

    @Test(groups={"smoke"})
    public void testInputOutput() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"InputOutput\"");
        FSDataBean input = this.manager.createDataBean("input.tsv", this.getClass().getResourceAsStream("/microarray.tsv"));
        job.addInput("input.tsv", input);
        this.executeJob(job);
        DataBean output = job.getOutput("output.tsv");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(output.getContentByteStream(), out);
        Assert.assertEquals("1\n2\n3\n", out.toString());
    }

    @Test(groups={"smoke"})
    public void testUniqueInputOutput() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"SimpleInputOutput\"");
        String inputString = Thread.currentThread().getName() + "_" + System.currentTimeMillis() + "\n";
        FSDataBean input = this.manager.createDataBean("input.dat", new ByteArrayInputStream(inputString.getBytes()));
        job.addInput("input.dat", input);
        this.executeJob(job, 360L, TimeUnit.SECONDS);
        DataBean output = job.getOutput("output.dat");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(output.getContentByteStream(), out);
        String outputString = new String(out.toByteArray());
        String expectedString = "INPUT WAS: " + inputString;
        if (!expectedString.equals(outputString)) {
            System.out.println("EX: " + expectedString + " OUT: " + outputString);
        }
        Assert.assertEquals(expectedString, outputString);
    }

    @Test(groups={"smoke"})
    public void fetchDescriptions() throws TaskException, InterruptedException, MicroarrayException {
        Task job = this.executor.createTask("describe");
        this.executeJob(job);
        String descriptions = new String(job.getOutput("description").getContents());
        Assert.assertTrue(descriptions.contains("ANALYSIS"));
    }

    @Test(groups={"smoke"})
    public void fetchSourceCode() throws TaskException, InterruptedException, MicroarrayException {
        Task job = this.executor.createTask("describe-operation");
        job.addParameter("operation-name", "\"Normalisation\"/\"Affymetrix\"");
        this.executeJob(job);
        String sourceCode = new String(job.getOutput("sourcecode").getContents());
        Assert.assertTrue(sourceCode.contains("Affymetrix normalization"));
    }

    @Test
    public void testInputSleepOutput() throws TaskException, InterruptedException, MicroarrayException {
        Task task = this.executor.createTask("\"Test\"/\"InputSleepOutput\"");
        String[] inputNames = new String[]{"GSM11805.cel", "GSM11814.cel", "GSM11823.cel", "GSM11830.cel"};
        int i = 1;
        for (String name : inputNames) {
            task.addInput("input" + i + ".cel", this.manager.createDataBean("input" + i + ".cel", this.getClass().getResourceAsStream("/kidney4-affy/" + name)));
            ++i;
        }
        this.executeJob(task);
    }

    @Test(groups={"smoke"})
    public void testCancelTask() throws TaskException, InterruptedException, MicroarrayException {
        Task task = this.executor.createTask("\"Test\"/\"InputSleepOutput\"");
        String[] inputNames = new String[]{"affy_example.cel"};
        int i = 1;
        for (String name : inputNames) {
            task.addInput("input" + i + ".cel", this.manager.createDataBean("input" + i + ".cel", this.getClass().getResourceAsStream("/" + name)));
            ++i;
        }
        CountDownLatch latch = new CountDownLatch(1);
        task.addTaskEventListener(new AnalysisTestBase.JobResultListener(latch));
        this.executor.startExecuting(task);
        Thread.sleep(1000L);
        this.executor.kill(task);
        assert (task.getState() == Task.State.CANCELLED);
    }

    @Test(threadPoolSize=5, invocationCount=30, groups={"stress"})
    public void testRNoOperationStress() throws Exception {
        this.testREcho();
    }

    @Test(threadPoolSize=10, invocationCount=200, groups={"stress"})
    public void testUniqueInputOutputStress() throws Exception {
        this.testUniqueInputOutput();
    }

    @Test
    public void testLargeInput() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"InputOutput\"");
        FSDataBean input = this.manager.createDataBean("neppi.tar.gz", new FileInputStream("/home/hupponen/neppi.tar.gz"));
        job.addInput("input.txt", input);
        this.executeJob(job, 6000L, TimeUnit.SECONDS);
        DataBean output = job.getOutput("output.txt");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(output.getContentByteStream(), out);
        Assert.assertEquals("1\n2\n3\n", out.toString());
    }

    @Test(groups={"smoke"})
    public void testScreenOutput() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"Fail\"");
        this.executeJob(job, Task.State.FAILED);
        System.out.println("Output: ");
        System.out.println(job.getScreenOutput());
        Assert.assertTrue(job.getScreenOutput().startsWith("\n> heipparallaa"));
        Assert.assertTrue(job.getScreenOutput().contains("Error:"));
    }

    @Test(groups={"stress"}, threadPoolSize=10, invocationCount=100)
    public void testScreenOutputStress() throws Exception {
        Task job = this.executor.createTask("\"Test\"/\"Fail\"");
        this.executeJob(job, Task.State.FAILED);
        System.out.println("Output: ");
        System.out.println(job.getScreenOutput());
        Assert.assertTrue(job.getScreenOutput().startsWith("\n> heipparallaa"));
        Assert.assertTrue(job.getScreenOutput().contains("Error:"));
    }
}

