/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray;

import fi.csc.microarray.util.config.Configuration;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.mortbay.util.IO;
import org.xml.sax.SAXException;

public class MicroarrayConfiguration {
    private static final String WORKSUBDIR = "nami-work-files";
    private static final File CONFIG_FILE = new File("nami-config.xml");
    private static final String STATIC_CONFIG_RESOURCENAME = "/nami-static-config.xml";
    private static final String[] WORKDIR_PROPERTY = new String[]{null, "nami_work_dir"};
    private static String DEFAULT_CONFIG_FILE = "/nami-config.xml.default";
    private static boolean alreadyLoaded = false;
    private static Configuration configuration = new Configuration(true);

    public static boolean loadConfiguration() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        return MicroarrayConfiguration.loadConfiguration(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadConfiguration(String overrideString, boolean useHomeAsWorkDir) throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        boolean defaultsUsed = false;
        Class<MicroarrayConfiguration> clazz = MicroarrayConfiguration.class;
        synchronized (MicroarrayConfiguration.class) {
            if (!alreadyLoaded) {
                String workDir;
                if (useHomeAsWorkDir) {
                    String home = System.getProperty("user.home");
                    workDir = home + File.separator + WORKSUBDIR;
                } else {
                    workDir = new File(WORKSUBDIR).getAbsolutePath();
                }
                new File(workDir).mkdirs();
                System.setProperty(WORKDIR_PROPERTY[1], workDir);
                File configFile = new File(workDir + File.separator + CONFIG_FILE.getName());
                if (!configFile.exists()) {
                    InputStream defaults = Configuration.class.getResourceAsStream(DEFAULT_CONFIG_FILE);
                    FileOutputStream out = new FileOutputStream(configFile);
                    try {
                        IO.copy(defaults, out);
                        defaultsUsed = true;
                    }
                    finally {
                        if (defaults != null) {
                            defaults.close();
                        }
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                }
                try {
                    ConfigurationLoader.addFromStream(configuration, MicroarrayConfiguration.class.getResourceAsStream(STATIC_CONFIG_RESOURCENAME), 0);
                    ConfigurationLoader.addFromFile(configuration, configFile, 0);
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
                configuration.putValueInSubmodule(WORKDIR_PROPERTY[0], WORKDIR_PROPERTY[1], workDir);
                if (overrideString != null) {
                    String[] overrides;
                    for (String override : overrides = overrideString.split(",")) {
                        String[] parts = override.split("=");
                        String[] nameParts = parts[0].split("/");
                        String moduleName = nameParts.length > 1 ? nameParts[0] : null;
                        String entryName = nameParts.length > 1 ? nameParts[1] : nameParts[0];
                        String[] values = parts[1].split(";");
                        if (values.length > 1) {
                            configuration.putValuesInSubmodule(moduleName, entryName, values);
                            continue;
                        }
                        configuration.putValueInSubmodule(moduleName, entryName, values[0]);
                    }
                }
            }
            alreadyLoaded = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return defaultsUsed;
        }
    }

    public static String[] getValues(String name) {
        return MicroarrayConfiguration.getValues(null, name);
    }

    public static String[] getValues(String moduleName, String name) {
        assert (alreadyLoaded);
        Configuration module = MicroarrayConfiguration.getModule(moduleName);
        return module.getValues(name);
    }

    public static String getValue(String name) {
        return MicroarrayConfiguration.getValue(null, name);
    }

    public static String getValue(String moduleName, String name) {
        assert (alreadyLoaded);
        Configuration module = MicroarrayConfiguration.getModule(moduleName);
        return module.getValue(name);
    }

    private static Configuration getModule(String moduleName) {
        return moduleName != null ? configuration.getModule(moduleName) : configuration;
    }

    public static File getWorkDir() {
        return new File(MicroarrayConfiguration.getValue(WORKDIR_PROPERTY[0], WORKDIR_PROPERTY[1]));
    }
}

