/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.util.IntSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseCorrelator
extends TransportFilter {
    private static final Log LOG = LogFactory.getLog(ResponseCorrelator.class);
    private final Map<Integer, FutureResponse> requestMap = new HashMap<Integer, FutureResponse>();
    private IntSequenceGenerator sequenceGenerator;
    private final boolean debug = LOG.isDebugEnabled();

    public ResponseCorrelator(Transport next) {
        this(next, new IntSequenceGenerator());
    }

    public ResponseCorrelator(Transport next, IntSequenceGenerator sequenceGenerator) {
        super(next);
        this.sequenceGenerator = sequenceGenerator;
    }

    public void oneway(Object o) throws IOException {
        Command command = (Command)o;
        command.setCommandId(this.sequenceGenerator.getNextSequenceId());
        command.setResponseRequired(false);
        this.next.oneway(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse asyncRequest(Object o, ResponseCallback responseCallback) throws IOException {
        Command command = (Command)o;
        command.setCommandId(this.sequenceGenerator.getNextSequenceId());
        command.setResponseRequired(true);
        FutureResponse future = new FutureResponse(responseCallback);
        Map<Integer, FutureResponse> map = this.requestMap;
        synchronized (map) {
            this.requestMap.put(new Integer(command.getCommandId()), future);
        }
        this.next.oneway(command);
        return future;
    }

    public Object request(Object command) throws IOException {
        FutureResponse response = this.asyncRequest(command, null);
        return response.getResult();
    }

    public Object request(Object command, int timeout) throws IOException {
        FutureResponse response = this.asyncRequest(command, null);
        return response.getResult(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Object o) {
        Command command = (Command)o;
        if (command.isResponse()) {
            Response response = (Response)command;
            FutureResponse future = null;
            Map<Integer, FutureResponse> map = this.requestMap;
            synchronized (map) {
                future = this.requestMap.remove(response.getCorrelationId());
            }
            if (future != null) {
                future.set(response);
            } else if (this.debug) {
                LOG.debug("Received unexpected response: {" + command + "}for command id: " + response.getCorrelationId());
            }
        } else {
            this.getTransportListener().onCommand(command);
        }
    }

    public void onException(IOException error) {
        ArrayList<FutureResponse> requests = new ArrayList<FutureResponse>(this.requestMap.values());
        this.requestMap.clear();
        for (FutureResponse fr : requests) {
            fr.set(new ExceptionResponse(error));
        }
        super.onException(error);
    }

    public IntSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public String toString() {
        return this.next.toString();
    }
}

