/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.configtool;

import fi.csc.microarray.util.XmlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigTool {
    private final String brokerDir = "activemq";
    private final String webstartDir = "webstart";
    private final String[] componentDirs = new String[]{"comp", "auth", "fileserver", "manager", "client"};
    private String[][] configs = new String[][]{{"Broker host", "myhost.mydomain"}, {"Broker protocol", "tcp"}, {"Broker port", "61616"}, {"Fileserver host", "myhost.mydomain"}, {"Fileserver port", "8080"}, {"URL of Web Start files", "http://myhost.mydomain"}, {"R command", "R"}};
    private final int KEY_INDEX = 0;
    private final int VAL_INDEX = 1;
    private final int BROKER_HOST_INDEX = 0;
    private final int BROKER_PROTOCOL_INDEX = 1;
    private final int BROKER_PORT_INDEX = 2;
    private final int FILEBROKER_HOST_INDEX = 3;
    private final int FILEBROKER_PORT_INDEX = 4;
    private final int WS_CODEBASE_INDEX = 5;
    private final int R_COMMAND_INDEX = 6;
    private String[][] passwords = new String[][]{{"comp", ""}, {"auth", ""}, {"manager", ""}};
    private HashMap<String, Document> documentsToWrite = new HashMap();
    private XmlUtil xml = XmlUtil.getInstance();

    public ConfigTool() throws ParserConfigurationException {
        System.out.println("Chipster ConfigTool");
        System.out.println("");
        System.out.println("No changes are written before you verify them");
        System.out.println("");
    }

    public static void main(String[] args) throws Exception {
        ConfigTool configTool = new ConfigTool();
        if ("configure".equals(args[0])) {
            configTool.configure();
        } else if ("genpasswd".equals(args[0])) {
            configTool.genpasswd();
        } else {
            System.out.println("Illegal arguments! Please specify one of: configure, genpasswd");
        }
    }

    private void genpasswd() throws Exception {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            for (int i = 0; i < this.passwords.length; ++i) {
                this.passwords[i][1] = UUID.randomUUID().toString();
            }
            for (String componentDir : this.componentDirs) {
                if (!new File(componentDir).exists()) continue;
                File configFile = new File(componentDir + File.separator + "nami-work-files" + File.separator + "nami-config.xml");
                this.updateChipsterConfigFilePasswords(configFile);
            }
            File activemqConfigFile = new File("activemq" + File.separator + "conf" + File.separator + "activemq.xml");
            if (activemqConfigFile.exists()) {
                this.updateActivemqConfigFilePasswords(activemqConfigFile);
            }
            this.verifyChanges(in);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        this.writeChangesToDisk();
    }

    private void writeChangesToDisk() throws TransformerException, UnsupportedEncodingException, FileNotFoundException {
        for (String file : this.documentsToWrite.keySet()) {
            System.out.println("Writing changes to " + file + "...");
            this.xml.printXml(this.documentsToWrite.get(file), new OutputStreamWriter(new FileOutputStream(file)));
        }
        System.out.println("\nAll changes successfully written!");
    }

    private void verifyChanges(BufferedReader in) throws Exception {
        System.out.println("Please verify changes. Should changes be written to disk [yes/no]?");
        String answer = in.readLine();
        if (!"yes".equals(answer)) {
            throw new Exception("User decided to abort");
        }
    }

    public void configure() throws Exception {
        try {
            File wsConfigFile;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                String host;
                this.configs[0][1] = host = InetAddress.getLocalHost().getHostName();
                this.configs[3][1] = host;
                this.configs[5][1] = "http://" + host + ":8081";
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            for (int i = 0; i < this.configs.length; ++i) {
                System.out.println("Please specify " + this.configs[i][0] + " [" + this.configs[i][1] + "]: ");
                String line = in.readLine();
                if (line.trim().equals("")) continue;
                this.configs[i][1] = line;
            }
            for (String componentDir : this.componentDirs) {
                if (!new File(componentDir).exists()) continue;
                File configFile = new File(componentDir + File.separator + "nami-work-files" + File.separator + "nami-config.xml");
                this.updateChipsterConfigFile(configFile);
            }
            File activemqConfigFile = new File("activemq" + File.separator + "conf" + File.separator + "activemq.xml");
            if (activemqConfigFile.exists()) {
                this.updateActivemqConfigFile(activemqConfigFile);
            }
            if ((wsConfigFile = new File("webstart" + File.separator + "web-content" + File.separator + "chipster.jnlp")).exists()) {
                this.updateWsConfigFile(wsConfigFile);
            }
            this.verifyChanges(in);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        this.writeChangesToDisk();
    }

    private void updateWsConfigFile(File configFile) throws SAXException, IOException, TransformerException, UnsupportedEncodingException, FileNotFoundException {
        Document doc = this.openForUpdating("Web Start", configFile);
        Element jnlp = doc.getDocumentElement();
        this.updateElementAttribute(jnlp, "codebase", this.configs[5][1]);
        Element applicationDesc = (Element)jnlp.getElementsByTagName("application-desc").item(0);
        NodeList arguments = applicationDesc.getElementsByTagName("argument");
        Element lastArgument = (Element)arguments.item(arguments.getLength() - 1);
        String override = "messaging/broker_host=" + this.configs[0][1] + ",messaging/broker_port=" + this.configs[2][1] + ",messaging/broker_protocol=" + this.configs[1][1] + ",messaging/filebroker_urls=" + this.createFilebrokerUrl();
        this.updateElementValue(lastArgument, "override argument", override);
        this.writeLater(configFile, doc);
    }

    private void updateActivemqConfigFile(File configFile) throws SAXException, IOException, TransformerException, UnsupportedEncodingException, FileNotFoundException {
        Document doc = this.openForUpdating("ActiveMQ", configFile);
        Element broker = (Element)doc.getDocumentElement().getElementsByTagName("broker").item(0);
        NodeList transportConnectors = broker.getElementsByTagName("transportConnectors");
        Element transportConnector = (Element)transportConnectors.item(0);
        String uri = this.configs[1][1] + "://" + this.configs[0][1] + ":" + this.configs[2][1];
        this.updateElementAttribute(transportConnector, "uri", uri);
        this.writeLater(configFile, doc);
    }

    private void updateActivemqConfigFilePasswords(File configFile) throws SAXException, IOException, TransformerException, UnsupportedEncodingException, FileNotFoundException {
        Document doc = this.openForUpdating("ActiveMQ", configFile);
        Element broker = (Element)doc.getDocumentElement().getElementsByTagName("broker").item(0);
        NodeList users = ((Element)((Element)((Element)broker.getElementsByTagName("plugins").item(0)).getElementsByTagName("simpleAuthenticationPlugin").item(0)).getElementsByTagName("users").item(0)).getElementsByTagName("authenticationUser");
        block0: for (int i = 0; i < users.getLength(); ++i) {
            for (int p = 0; p < this.passwords.length; ++p) {
                Element user = (Element)users.item(i);
                if (!user.getAttribute("username").equals(this.passwords[p][0])) continue;
                this.updateElementAttribute(user, "password for " + this.passwords[p][0], "password", this.passwords[p][1]);
                continue block0;
            }
        }
        this.writeLater(configFile, doc);
    }

    private void updateChipsterConfigFilePasswords(File configFile) throws Exception {
        Document doc = this.openForUpdating("Chipster", configFile);
        Element securityModule = this.xml.getChildWithAttribute(doc.getDocumentElement(), "moduleId", "security");
        Element usernameElement = this.xml.getChildWithAttribute(securityModule, "entryKey", "username");
        String username = ((Element)usernameElement.getElementsByTagName("value").item(0)).getTextContent();
        for (int i = 0; i < this.passwords.length; ++i) {
            if (!username.equals(this.passwords[i][0])) continue;
            this.updateConfigEntryValue(securityModule, "password", this.passwords[i][1]);
            break;
        }
        this.writeLater(configFile, doc);
    }

    private void updateChipsterConfigFile(File configFile) throws Exception {
        Document doc = this.openForUpdating("Chipster", configFile);
        Element messagingModule = this.xml.getChildWithAttribute(doc.getDocumentElement(), "moduleId", "messaging");
        this.updateConfigEntryValue(messagingModule, "broker_host", this.configs[0][1]);
        this.updateConfigEntryValue(messagingModule, "broker_protocol", this.configs[1][1]);
        this.updateConfigEntryValue(messagingModule, "broker_port", this.configs[2][1]);
        String filebrokerUrl = this.createFilebrokerUrl();
        this.updateConfigEntryValue(messagingModule, "filebroker_urls", filebrokerUrl);
        Element filebrokerModule = this.xml.getChildWithAttribute(doc.getDocumentElement(), "moduleId", "filebroker");
        this.updateConfigEntryValue(filebrokerModule, "port", this.configs[4][1]);
        Element analyserModule = this.xml.getChildWithAttribute(doc.getDocumentElement(), "moduleId", "analyser");
        this.updateConfigEntryValue(analyserModule, "RCommand", this.configs[6][1]);
        this.writeLater(configFile, doc);
    }

    private String createFilebrokerUrl() {
        String filebrokerUrl = "http://" + this.configs[3][1] + ":" + this.configs[4][1] + "/fileserver";
        return filebrokerUrl;
    }

    private void updateConfigEntryValue(Element module, String name, String newValue) {
        Element entry = this.xml.getChildWithAttribute(module, "entryKey", name);
        Element value = (Element)entry.getElementsByTagName("value").item(0);
        this.updateElementValue(value, name, newValue);
    }

    private void updateElementValue(Element element, String logicalName, String newValue) {
        System.out.println("  changing " + logicalName + ": " + element.getTextContent() + " -> " + newValue);
        element.setTextContent(newValue);
    }

    private void updateElementAttribute(Element element, String attrName, String attrValue) {
        this.updateElementAttribute(element, attrName, attrName, attrValue);
    }

    private void updateElementAttribute(Element element, String logicalName, String attrName, String attrValue) {
        System.out.println("  changing " + logicalName + ": " + element.getAttribute(attrName) + " -> " + attrValue);
        element.setAttribute(attrName, attrValue);
    }

    private void writeLater(File configFile, Document doc) throws TransformerException, UnsupportedEncodingException, FileNotFoundException {
        this.documentsToWrite.put(configFile.getAbsolutePath(), doc);
        System.out.println("");
    }

    private Document openForUpdating(String name, File configFile) throws SAXException, IOException {
        System.out.println("Updating " + name + " config in " + configFile.getAbsolutePath());
        Document doc = this.xml.parseFile(configFile);
        return doc;
    }
}

