/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.active.BatchedWrite;
import org.apache.activeio.journal.active.Location;
import org.apache.activeio.journal.active.LogFileManager;
import org.apache.activeio.journal.active.Record;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.ByteBufferPacket;
import org.apache.activeio.packet.Packet;

public class LogFileManagerTest
extends TestCase {
    int size = 524288;
    int logFileCount = 4;
    File logDirectory = new File("test-logfile");
    private LogFileManager logFile;

    protected void setUp() throws Exception {
        if (this.logDirectory.exists()) {
            this.deleteDir(this.logDirectory);
        }
        LogFileManagerTest.assertTrue((!this.logDirectory.exists() ? 1 : 0) != 0);
        this.logFile = new LogFileManager(this.logDirectory, this.logFileCount, this.size, null);
    }

    private void deleteDir(File f) {
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            file.delete();
        }
        f.delete();
    }

    protected void tearDown() throws Exception {
        this.logFile.dispose();
        if (this.logDirectory.exists()) {
            this.deleteDir(this.logDirectory);
        }
        LogFileManagerTest.assertTrue((!this.logDirectory.exists() ? 1 : 0) != 0);
    }

    public void testLogFileCreation() throws IOException {
        LogFileManagerTest.assertTrue((boolean)this.logFile.canActivateNextLogFile());
        LogFileManagerTest.assertEquals(null, (Object)this.logFile.getFirstActiveLogLocation());
        LogFileManagerTest.assertNull((Object)this.logFile.getLastMarkedRecordLocation());
        LogFileManagerTest.assertEquals((Object)new Location(0, 0), (Object)this.logFile.getNextAppendLocation());
    }

    public void testAppendAndRead() throws IOException, InvalidRecordLocationException, InterruptedException {
        System.out.println("Initial:" + this.logFile.getNextAppendLocation());
        this.appendHelloRecord(1001);
        Location loc2 = this.logFile.getNextAppendLocation();
        this.appendHelloRecord(2002);
        this.appendHelloRecord(3003);
        this.appendHelloRecord(3004);
        Location loc3 = this.logFile.getNextDataRecordLocation(loc2);
        LogFileManagerTest.assertTrue((loc3.getLogFileOffset() > loc2.getLogFileOffset() ? 1 : 0) != 0);
        Location loc4 = this.logFile.getNextDataRecordLocation(loc3);
        LogFileManagerTest.assertTrue((loc4.getLogFileOffset() > loc3.getLogFileOffset() ? 1 : 0) != 0);
    }

    public void testRollOver() throws IOException, InvalidRecordLocationException, InterruptedException {
        int lastId = this.logFile.getNextAppendLocation().getLogFileId();
        int counter = 0;
        for (int i = 0; i < this.logFileCount; ++i) {
            this.appendHelloRecord(counter += 500);
            if (i + 1 == this.logFileCount) {
                LogFileManagerTest.assertFalse((boolean)this.logFile.canActivateNextLogFile());
                continue;
            }
            LogFileManagerTest.assertTrue((boolean)this.logFile.canActivateNextLogFile());
            this.logFile.activateNextLogFile();
            LogFileManagerTest.assertEquals((int)(lastId + 1), (int)this.logFile.getNextAppendLocation().getLogFileId());
            lastId = this.logFile.getNextAppendLocation().getLogFileId();
        }
    }

    private void appendHelloRecord(int i) throws IOException, InterruptedException {
        byte[] data = ("Hello World: " + i).getBytes();
        Record batchedRecord = new Record(1, (Packet)new ByteArrayPacket(data), null);
        batchedRecord.setLocation(this.logFile.getNextAppendLocation());
        BatchedWrite write = new BatchedWrite((Packet)new ByteBufferPacket(ByteBuffer.allocate(1024)));
        write.append(batchedRecord, null, true);
        write.flip();
        this.logFile.append(write);
    }
}

