/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.cursors.AbstractStoreCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TopicStorePrefetch
extends AbstractStoreCursor {
    private static final Log LOG = LogFactory.getLog(TopicStorePrefetch.class);
    private TopicMessageStore store;
    private final LinkedHashMap<MessageId, Message> batchList = new LinkedHashMap();
    private String clientId;
    private String subscriberName;
    private Subscription subscription;

    public TopicStorePrefetch(Subscription subscription, Topic topic, String clientId, String subscriberName) {
        super(topic);
        this.subscription = subscription;
        this.store = (TopicMessageStore)topic.getMessageStore();
        this.clientId = clientId;
        this.subscriberName = subscriberName;
        this.maxProducersToAudit = 32;
        this.maxAuditDepth = 10000;
    }

    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
        throw new RuntimeException("Not supported");
    }

    public synchronized void dispatched(MessageReference message) {
        if (this.audit != null) {
            this.isDuplicate(message.getMessageId());
            Message removed = (Message)this.batchList.remove(message.getMessageId());
            if (removed != null) {
                removed.decrementReferenceCount();
            }
        }
    }

    public synchronized boolean recoverMessage(Message message, boolean cached) throws Exception {
        NonCachedMessageEvaluationContext messageEvaluationContext = new NonCachedMessageEvaluationContext();
        ((MessageEvaluationContext)messageEvaluationContext).setMessageReference(message);
        if (this.subscription.matches(message, messageEvaluationContext)) {
            return super.recoverMessage(message, cached);
        }
        return false;
    }

    protected synchronized int getStoreSize() {
        try {
            return this.store.getMessageCount(this.clientId, this.subscriberName);
        }
        catch (IOException e) {
            LOG.error((Object)(this + " Failed to get the outstanding message count from the store"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void resetBatch() {
        this.store.resetBatching(this.clientId, this.subscriberName);
    }

    protected void doFillBatch() throws Exception {
        this.store.recoverNextMessages(this.clientId, this.subscriberName, this.maxBatchSize, this);
    }

    public String toString() {
        return "TopicStorePrefetch" + System.identityHashCode(this) + "(" + this.clientId + "," + this.subscriberName + ")";
    }
}

