# ANALYSIS "Sequence analysis"/"MSA" (Does a multiple sequence alignment to sequences. This tool needs a sequence
# file in FastA format. Output is a sequence alignment in Clustal format.) 
# INPUT GENERIC seqs.txt OUTPUT aligned-seqs.txt 
# PARAMETER program [muscle, mafft] DEFAULT muscle (Which program to use)
# PARAMETER method [slow, fast] DEFAULT slow (Use slow or fast settings)
# PARAMETER seqtype [DNA, protein] DEFAULT DNA (Are the sequences DNA or protein)


# Sets the path the muscle executable
path.muscle<-c("muscle")

# Sets the path the mafft executable
path.mafft<-c("mafft")

# Runs the analysis
if(program=="muscle" & method=="slow" & seqtype=="DNA") {
   system(paste(path.muscle, " -in seqs.txt -out aligned-seqs.txt -clwstrict -seqtype nucleo -stable", sep=""))
}

if(program=="muscle" & method=="fast" & seqtype=="DNA") {
   system(paste(path.muscle, " -in seqs.txt -out aligned-seqs.txt -clwstrict -maxiters 1 -diags 1 -seqtype nucleo -stable", sep=""))
}

if(program=="muscle" & method=="slow" & seqtype=="protein") {
   system(paste(path.muscle, " -in seqs.txt -out aligned-seqs.txt -clwstrict -seqtype protein -stable", sep=""))
}

if(program=="muscle" & method=="fast" & seqtype=="protein") {
   system(paste(path.muscle, " -in seqs.txt -out aligned-seqs.txt -clwstrict -seqtype protein -maxiters 1 -diags1 -sv -distance1 kbit20_3 -stable", sep=""))
}

if(program=="mafft" & method=="slow" & seqtype=="DNA") {
   system(paste(path.mafft, " --localpair --maxiterate 1000 --clustalout --inputorder --nuc seqs.txt > aligned-seqs.txt", sep=""))
}

if(program=="mafft" & method=="slow" & seqtype=="protein") {
   system(paste(path.mafft, " --localpair --maxiterate 1000 --clustalout --inputorder --amino seqs.txt > aligned-seqs.txt", sep=""))
}

if(program=="mafft" & method=="fast" & seqtype=="DNA") {
   system(paste(path.mafft, " --retree 2 --maxiterate 0 --clustalout --inputorder --nuc seqs.txt > aligned-seqs.txt", sep=""))
}

if(program=="mafft" & method=="fast" & seqtype=="protein") {
   system(paste(path.mafft, " --retree 2 --maxiterate 0 --clustalout --inputorder --amino seqs.txt > aligned-seqs.txt", sep=""))
}
