/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.editor;

import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Point2D;
import java.awt.Point;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ResourceBundle;

import java.lang.IllegalArgumentException;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jfree.ui.RectangleEdge;

import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.axis.HeatMapAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.entity.HeatMapBlockEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.renderer.RendererState;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HeatMap;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.HCTreeNode;

/**
 * xxx
 *
 * @author viski project.
 */
public class HCOptionsEditor implements ChangeListener {


    private JCheckBox horizontalClusteringCB;
    private JCheckBox verticalClusteringCB;
    private JCheckBox rowNamesCB;
    private JCheckBox columnNamesCB;
    private HCPlot plot;

    public HCOptionsEditor (HCPlot plot) {

	this.plot = plot;
	this.horizontalClusteringCB = null;
	this.verticalClusteringCB = null;
	this.rowNamesCB = null;
	this.columnNamesCB = null;
	
    }

    /**
     * Listens for input widget events.
     *
     * @param e  the event.
     */
    public void stateChanged(ChangeEvent e) {

        if (e.getSource() == this.horizontalClusteringCB) {

            boolean value = this.horizontalClusteringCB.isSelected();
            if (value) this.plot.showColumnTree();
	    else this.plot.hideColumnTree();

        } else if (e.getSource() == this.verticalClusteringCB) {

            boolean value = this.verticalClusteringCB.isSelected();
            if (value) this.plot.showRowTree();
	    else this.plot.hideRowTree();

        } else if (e.getSource() == this.columnNamesCB) {

            boolean value = this.columnNamesCB.isSelected();
            if (value) this.plot.showColumnNames();
	    else this.plot.hideColumnNames();

        } else if (e.getSource() == this.rowNamesCB) {

            boolean value = this.rowNamesCB.isSelected();
            if (value) this.plot.showRowNames();
	    else this.plot.hideRowNames();

        }

    }
    /**
     * Creates a new JPanel for adjusting HCPlot options.
     *
     * @return  The panel.
     */
    public JPanel getPanel() {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.LocalizationBundle");
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();

        panel.setLayout(new GridBagLayout());
        c.fill = GridBagConstraints.VERTICAL;
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));

	c.gridx = 0;
	c.gridy = 0;
	this.horizontalClusteringCB = new JCheckBox(
            lr.getString("Show_column_clustering"),
	    this.plot.getColumnTreeVisibility()
	);
	this.horizontalClusteringCB.addChangeListener(this);
	panel.add(this.horizontalClusteringCB,c);

	c.gridy++;
	this.verticalClusteringCB = new JCheckBox(
	    lr.getString("Show_row_clustering"),
	    this.plot.getRowTreeVisibility()
	);
	this.verticalClusteringCB.addChangeListener(this);
	panel.add(this.verticalClusteringCB,c);

	c.gridy++;
	this.columnNamesCB = new JCheckBox(
	    lr.getString("Show_column_names"),
	    this.plot.getColumnNamesVisibility()
	);
	this.columnNamesCB.addChangeListener(this);
	panel.add(this.columnNamesCB,c);

	c.gridy++;
	this.rowNamesCB = new JCheckBox(
	    lr.getString("Show_row_names"),
	    this.plot.getRowNamesVisibility()
	);
	this.rowNamesCB.addChangeListener(this);
	panel.add(this.rowNamesCB,c);

        return panel;
    }

}

