package org.jfree.chart.demo;

import org.jfree.chart.plot.SOMPlot;
import java.awt.*;
import java.util.*;
import org.jfree.chart.*;
import javax.swing.*;
import org.jfree.data.som.*;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

/**
 * Demo program for MultiCharts.
 */
public class MultiChartSaveDemo extends ApplicationFrame {

    //THE LIST, which has the bookkeeping of multichartpanels
    public java.util.List panels;

    /**
     * Creates a new demo instance.
     *
     * @param title  the frame title.
     */
    public MultiChartSaveDemo(String title) {
	super(title);
        panels = new ArrayList();

        SOMDataset dataset = org.jfree.chart.demo.SOMChartDemo1.createDataset();

        JFreeChart chart = ChartFactory.createSOMChart("SOM1", dataset, true, false);
        MultiChartPanel panel1 = new MultiChartPanel(chart, panels);
        panel1.addChartMouseListener((SOMPlot)chart.getPlot());
//        panel1.addKeyListener((SOMPlot)chart.getPlot());
	panels.add(panel1);
	panel1.setPreferredSize(new Dimension(400,400));
 
        JFreeChart chart2 = ChartFactory.createSOMChart("SOM2", dataset, true, false);
	MultiChartPanel panel2 = new MultiChartPanel(chart2, panels);
        panel2.addChartMouseListener((SOMPlot)chart2.getPlot());
//        panel2.addKeyListener((SOMPlot)chart2.getPlot());
	panels.add(panel2);
	panel2.setPreferredSize(new Dimension(400,400));

        JFreeChart chart3 = ChartFactory.createSOMChart("SOM3", dataset, true, false);
	MultiChartPanel panel3 = new MultiChartPanel(chart3, panels);
	panels.add(panel3);
	panel3.setPreferredSize(new Dimension(400,400));
/*
        JFreeChart chart4 = ChartFactory.createSOMChart("SOM4", dataset, true, false);
	MultiChartPanel panel4 = new MultiChartPanel(chart4, false, panels);
	panels.add(panel4);
	panel4.setPreferredSize(new Dimension(400,400));
*/
        this.getContentPane().add(panel1, BorderLayout.WEST);
        this.getContentPane().add(panel2, BorderLayout.EAST);
        this.getContentPane().add(panel3, BorderLayout.SOUTH);
//        this.getContentPane().add(panel4, BorderLayout.SOUTH);
		
    }

    /**
     * Starting point for the demonstration application.
     *
     * @param args  ignored.
     */
    public static void main(String[] args) {

        MultiChartSaveDemo demo = new MultiChartSaveDemo("Save testing");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
   }

}
