/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.BioChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.SOMPlot;
import org.jfree.data.som.SOMDataItem;
import org.jfree.data.som.SOMDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class SOMChartDemo1
extends ApplicationFrame {
    public static final int DEFAULT_WIDTH = 10;
    public static final int DEFAULT_HEIGHT = 10;

    public SOMChartDemo1(String title, int columns, int rows) {
        super(title);
        SOMDataset dataset = SOMChartDemo1.createDataset(columns, rows);
        JFreeChart chart = SOMChartDemo1.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart, false);
        chartPanel.addChartMouseListener((SOMPlot)chart.getPlot());
        chartPanel.setFocusable(true);
        chartPanel.setPreferredSize(new Dimension(400, 400));
        this.setContentPane(chartPanel);
    }

    public static SOMDataset createDataset() {
        return SOMChartDemo1.createDataset(10, 10);
    }

    public static SOMDataset createDataset(int columns, int rows) {
        SOMDataset dataset = null;
        try {
            dataset = new SOMDataset(columns, rows);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    String[] s = new String[]{"BLUE", "private static SOMDataset createDataset()"};
                    double[] w = new double[]{Math.random(), Math.random(), Math.random()};
                    float r = (float)Math.random();
                    float g = (float)Math.random();
                    float b = (float)Math.random();
                    Color clr = new Color(r, g, b);
                    SOMDataItem sdi = new SOMDataItem(clr, s, w);
                    dataset.addValue(j, i, sdi);
                }
            }
        }
        catch (Exception e) {
            System.err.println("SOM data initialization failed.");
            System.exit(1);
        }
        return dataset;
    }

    private static JFreeChart createChart(SOMDataset dataset) {
        JFreeChart chart = BioChartFactory.createSOMChart("SOM Chart Demo", dataset, true, false);
        return chart;
    }

    public static void main(String[] args) {
        int columns = 10;
        int rows = 10;
        if (args.length > 0) {
            try {
                columns = Integer.parseInt(args[0], 10);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (args.length > 1) {
            try {
                rows = Integer.parseInt(args[1], 10);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        SOMChartDemo1 demo = new SOMChartDemo1("SOM Chart Demo", columns, rows);
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }
}

