/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.language.IllegalSyntaxException;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLanguage
implements Language {
    public static Expression simple(String expression) {
        SimpleLanguage language = new SimpleLanguage();
        return language.createExpression(expression);
    }

    @Override
    public Predicate<Exchange> createPredicate(String expression) {
        return PredicateBuilder.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression<Exchange> createExpression(String expression) {
        if (expression.indexOf("${") >= 0) {
            return this.createComplexExpression(expression);
        }
        return this.createSimpleExpression(expression);
    }

    protected Expression<Exchange> createComplexExpression(String expression) {
        ArrayList<Expression> results = new ArrayList<Expression>();
        int pivot = 0;
        int size = expression.length();
        while (pivot < size) {
            int endIdx;
            int idx = expression.indexOf("${", pivot);
            if (idx < 0) {
                results.add(this.createConstantExpression(expression, pivot, size));
                break;
            }
            if (pivot < idx) {
                results.add(this.createConstantExpression(expression, pivot, idx));
            }
            if ((endIdx = expression.indexOf("}", pivot = idx + 2)) < 0) {
                throw new IllegalArgumentException("Expecting } but found end of string for simple expression: " + expression);
            }
            String simpleText = expression.substring(pivot, endIdx);
            Expression<Exchange> simpleExpression = this.createSimpleExpression(simpleText);
            results.add(simpleExpression);
            pivot = endIdx + 1;
        }
        return ExpressionBuilder.concatExpression(results, expression);
    }

    protected Expression createConstantExpression(String expression, int start, int end) {
        return ExpressionBuilder.constantExpression(expression.substring(start, end));
    }

    protected Expression<Exchange> createSimpleExpression(String expression) {
        if (ObjectHelper.isEqualToAny(expression, "body", "in.body")) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal(expression, "out.body")) {
            return ExpressionBuilder.outBodyExpression();
        }
        String remainder = this.ifStartsWithReturnRemainder("in.header.", expression);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header.", expression);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers.", expression);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.headers.", expression);
        }
        if (remainder != null) {
            return ExpressionBuilder.headerExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("out.header.", expression);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.headers.", expression);
        }
        if (remainder != null) {
            return ExpressionBuilder.outHeaderExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("property.", expression);
        if (remainder != null) {
            return ExpressionBuilder.propertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", expression);
        if (remainder != null) {
            return ExpressionBuilder.propertyExpression(remainder);
        }
        throw new IllegalSyntaxException(this, expression);
    }

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }
}

