/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.IOException;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.strategy.DefaultFileRenamer;
import org.apache.camel.component.file.strategy.FileProcessStrategySupport;
import org.apache.camel.component.file.strategy.FileRenamer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenameFileProcessStrategy
extends FileProcessStrategySupport {
    private static final transient Log LOG = LogFactory.getLog(RenameFileProcessStrategy.class);
    private FileRenamer renamer;

    public RenameFileProcessStrategy() {
        this(true);
    }

    public RenameFileProcessStrategy(boolean lock) {
        this(lock, ".camel/", "");
    }

    public RenameFileProcessStrategy(boolean lock, String namePrefix, String namePostfix) {
        this(lock, new DefaultFileRenamer(namePrefix, namePostfix));
    }

    public RenameFileProcessStrategy(boolean lock, FileRenamer renamer) {
        super(lock);
        this.renamer = renamer;
    }

    public void commit(FileEndpoint endpoint, FileExchange exchange, File file) throws Exception {
        boolean renamed;
        File newName = this.renamer.renameFile(file);
        newName.getParentFile().mkdirs();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming file: " + file + " to: " + newName));
        }
        if (!(renamed = file.renameTo(newName))) {
            throw new IOException("Could not rename file from: " + file + " to " + newName);
        }
        super.commit(endpoint, exchange, file);
    }

    public FileRenamer getRenamer() {
        return this.renamer;
    }

    public void setRenamer(FileRenamer renamer) {
        this.renamer = renamer;
    }
}

