/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect;

import java.util.Arrays;
import org.fest.reflect.ReflectionError;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor<T> {
    private final java.lang.reflect.Constructor<T> constructor;
    private final boolean accessible;

    Constructor(Class<T> target, Class<?> ... parameterTypes) {
        this.constructor = this.constructor(target, parameterTypes);
        this.accessible = this.constructor.isAccessible();
    }

    private java.lang.reflect.Constructor<T> constructor(Class<T> target, Class<?> ... parameterTypes) {
        try {
            return target.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find constructor in type ", target.getName(), " with parameter types ", Arrays.toString(parameterTypes)}), e);
        }
    }

    public T newInstance(Object ... args) {
        try {
            this.constructor.setAccessible(true);
            T newInstance = this.constructor.newInstance(args);
            this.constructor.setAccessible(this.accessible);
            return newInstance;
        }
        catch (Exception e) {
            throw new ReflectionError("Unable to create a new object from the enclosed constructor", e);
        }
    }

    public java.lang.reflect.Constructor<T> info() {
        return this.constructor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterTypes {
        private final Class<?>[] parameterTypes;

        ParameterTypes(Class<?>[] parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        public <T> Constructor<T> in(Class<T> target) {
            return new Constructor<T>(target, this.parameterTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TargetType {
        TargetType() {
        }

        public <T> Constructor<T> in(Class<T> target) {
            return new Constructor<T>(target, new Class[0]);
        }

        public ParameterTypes withParameterTypes(Class<?> ... parameterTypes) {
            return new ParameterTypes(parameterTypes);
        }
    }
}

