/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.SimpleTopicTest;
import org.apache.activemq.perf.SlowConsumer;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SlowConsumerTopicTest
extends SimpleTopicTest {
    protected PerfConsumer[] slowConsumers;

    protected void setUp() throws Exception {
        this.playloadSize = 10240;
        super.setUp();
    }

    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        return new SlowConsumer(fac, dest);
    }

    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number, byte[] payload) throws JMSException {
        PerfProducer result = super.createProducer(fac, dest, number, payload);
        result.setDeliveryMode(1);
        return result;
    }

    protected BrokerService createBroker() throws Exception {
        ClassPathResource resource = new ClassPathResource("org/apache/activemq/perf/slowConsumerBroker.xml");
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        broker.start();
        return broker;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory result = super.createConnectionFactory(this.bindAddress);
        ActiveMQPrefetchPolicy policy = new ActiveMQPrefetchPolicy();
        policy.setTopicPrefetch(1000);
        result.setPrefetchPolicy(policy);
        return result;
    }
}

