/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.load;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.perf.PerfRate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadClient
implements Runnable {
    private static final Log LOG = LogFactory.getLog(LoadClient.class);
    protected static int SLEEP_TIME = 2;
    protected String name;
    protected ConnectionFactory factory;
    protected Connection connection;
    protected Destination startDestination;
    protected Destination nextDestination;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected PerfRate rate = new PerfRate();
    protected int deliveryMode = 2;
    protected ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
    protected boolean connectionPerMessage = false;
    protected boolean running;
    protected int timeout = 10000;

    public LoadClient(String name, ConnectionFactory factory) {
        this.name = name;
        this.factory = factory;
    }

    public synchronized void start() throws JMSException {
        if (!this.running) {
            this.rate.reset();
            this.running = true;
            if (!this.connectionPerMessage) {
                this.connection = this.factory.createConnection();
                this.connection.start();
                this.session = this.connection.createSession(false, 1);
                this.consumer = this.session.createConsumer(this.getConsumeDestination());
                this.producer = this.session.createProducer(this.getSendDestination());
                this.producer.setDeliveryMode(this.deliveryMode);
            }
            Thread t = new Thread(this);
            t.setName(this.name);
            t.start();
        }
    }

    public void stop() throws JMSException, InterruptedException {
        this.running = false;
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    public void run() {
        try {
            while (this.running) {
                String result = this.consume();
                if (result != null) {
                    this.send(result);
                    this.rate.increment();
                    continue;
                }
                if (!this.running) continue;
                LOG.error((Object)(this.name + " Failed to consume!"));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected String consume() throws Exception {
        TextMessage result;
        Connection con = null;
        MessageConsumer c = this.consumer;
        if (this.connectionPerMessage) {
            con = this.factory.createConnection();
            con.start();
            Session s = con.createSession(false, 1);
            c = s.createConsumer(this.getConsumeDestination());
        }
        if ((result = (TextMessage)c.receive((long)this.timeout)) != null) {
            if (this.audit.isDuplicate(result.getJMSMessageID())) {
                throw new JMSException("Received duplicate " + result.getText());
            }
            if (!this.audit.isInOrder(result.getJMSMessageID())) {
                throw new JMSException("Out of order " + result.getText());
            }
            if (this.connectionPerMessage) {
                Thread.sleep(SLEEP_TIME);
                con.close();
            }
        }
        return result != null ? result.getText() : null;
    }

    protected void send(String text) throws Exception {
        Connection con = this.connection;
        MessageProducer p = this.producer;
        Session s = this.session;
        if (this.connectionPerMessage) {
            con = this.factory.createConnection();
            con.start();
            s = con.createSession(false, 1);
            p = s.createProducer(this.getSendDestination());
            p.setDeliveryMode(this.deliveryMode);
        }
        TextMessage message = s.createTextMessage(text);
        p.send((Message)message);
        if (this.connectionPerMessage) {
            Thread.sleep(SLEEP_TIME);
            con.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Destination getStartDestination() {
        return this.startDestination;
    }

    public void setStartDestination(Destination startDestination) {
        this.startDestination = startDestination;
    }

    public Destination getNextDestination() {
        return this.nextDestination;
    }

    public void setNextDestination(Destination nextDestination) {
        this.nextDestination = nextDestination;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public boolean isConnectionPerMessage() {
        return this.connectionPerMessage;
    }

    public void setConnectionPerMessage(boolean connectionPerMessage) {
        this.connectionPerMessage = connectionPerMessage;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Destination getSendDestination() {
        return this.nextDestination;
    }

    protected Destination getConsumeDestination() {
        return this.startDestination;
    }
}

