/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.DataStructureTestSupport;

public class ActiveMQDestinationTest
extends DataStructureTestSupport {
    public ActiveMQDestination destination;

    public void initCombosForTestDesintaionMarshaling() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST"), new ActiveMQTempQueue("TEST:1"), new ActiveMQTempTopic("TEST:1"), new ActiveMQTempQueue("TEST"), new ActiveMQTempTopic("TEST"), new ActiveMQQueue("TEST?option=value"), new ActiveMQTopic("TEST?option=value"), new ActiveMQTempQueue("TEST:1?option=value"), new ActiveMQTempTopic("TEST:1?option=value")});
    }

    public void testDesintaionMarshaling() throws IOException {
        this.assertBeanMarshalls(this.destination);
    }

    public void initCombosForTestDesintaionOptions() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST?k1=v1&k2=v2"), new ActiveMQTopic("TEST?k1=v1&k2=v2"), new ActiveMQTempQueue("TEST:1?k1=v1&k2=v2"), new ActiveMQTempTopic("TEST:1?k1=v1&k2=v2")});
    }

    public void testDesintaionOptions() throws IOException {
        Map options = this.destination.getOptions();
        ActiveMQDestinationTest.assertNotNull((Object)options);
        ActiveMQDestinationTest.assertEquals("v1", options.get("k1"));
        ActiveMQDestinationTest.assertEquals("v2", options.get("k2"));
    }

    public void testSorting() throws Exception {
        TreeSet<ActiveMQDestination> set = new TreeSet<ActiveMQDestination>();
        ActiveMQDestination[] destinations = new ActiveMQDestination[]{new ActiveMQQueue("A"), new ActiveMQQueue("B"), new ActiveMQTopic("A"), new ActiveMQTopic("B")};
        List<ActiveMQDestination> expected = Arrays.asList(destinations);
        set.addAll(expected);
        ArrayList actual = new ArrayList(set);
        ActiveMQDestinationTest.assertEquals((String)"Sorted order", expected, actual);
    }

    public static Test suite() {
        return ActiveMQDestinationTest.suite(ActiveMQDestinationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ActiveMQDestinationTest.suite());
    }
}

