/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.camel.converter.ActiveMQConverter;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQReplyToHeaderUsingConverterTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(ActiveMQReplyToHeaderUsingConverterTest.class);
    protected Object expectedBody = "<time>" + new Date() + "</time>";
    protected String replyQueueName = "queue://test.my.reply.queue";
    protected String correlationID = "ABC-123";
    protected String groupID = "GROUP-XYZ";
    protected String messageType = ((Object)((Object)this)).getClass().getName();
    protected boolean useReplyToHeader = false;

    public void testSendingAMessageFromCamelSetsCustomJmsHeaders() throws Exception {
        MockEndpoint resultEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{this.expectedBody});
        AssertionClause firstMessage = resultEndpoint.message(0);
        firstMessage.header("cheese").isEqualTo((Object)123);
        firstMessage.header("JMSCorrelationID").isEqualTo((Object)this.correlationID);
        if (this.useReplyToHeader) {
            firstMessage.header("JMSReplyTo").isEqualTo((Object)ActiveMQConverter.toDestination((String)this.replyQueueName));
        }
        firstMessage.header("JMSType").isEqualTo((Object)this.messageType);
        firstMessage.header("JMSXGroupID").isEqualTo((Object)this.groupID);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("cheese", 123);
        if (this.useReplyToHeader) {
            headers.put("JMSReplyTo", this.replyQueueName);
        }
        headers.put("JMSCorrelationID", this.correlationID);
        headers.put("JMSType", this.messageType);
        headers.put("JMSXGroupID", this.groupID);
        this.template.sendBodyAndHeaders("activemq:test.a", this.expectedBody, headers);
        resultEndpoint.assertIsSatisfied();
        List list = resultEndpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Message in = exchange.getIn();
        Object replyTo = in.getHeader("JMSReplyTo");
        LOG.info((Object)("Reply to is: " + replyTo));
        if (this.useReplyToHeader) {
            Destination destination = (Destination)this.assertIsInstanceOf(Destination.class, replyTo);
            ActiveMQReplyToHeaderUsingConverterTest.assertEquals((String)"ReplyTo", (String)this.replyQueueName, (String)destination.toString());
        }
        this.assertMessageHeader(in, "cheese", 123);
        this.assertMessageHeader(in, "JMSCorrelationID", this.correlationID);
        this.assertMessageHeader(in, "JMSType", this.messageType);
        this.assertMessageHeader(in, "JMSXGroupID", this.groupID);
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.addComponent("activemq", (Component)ActiveMQComponent.activeMQComponent((String)"vm://localhost?broker.persistent=false"));
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("activemq:test.a").to("activemq:test.b");
                this.from("activemq:test.b").to("mock:result");
            }
        };
    }
}

