/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.demo.DefaultQueueSender;

public final class Main {
    protected static boolean createConsumers;

    private Main() {
    }

    public static void main(String[] args) {
        try {
            BrokerService broker = new BrokerService();
            broker.setPersistent(false);
            ManagementContext managementContext = broker.getManagementContext();
            managementContext.setFindTigerMbeanServer(true);
            managementContext.setUseMBeanServer(true);
            managementContext.setCreateConnector(false);
            broker.setUseJmx(true);
            broker.addConnector("tcp://localhost:61616");
            broker.addConnector("stomp://localhost:61613");
            broker.start();
            DefaultQueueSender.main(new String[]{"Prices.Equity.IBM"});
            DefaultQueueSender.main(new String[]{"Prices.Equity.MSFT"});
            if (createConsumers) {
                Connection connection = new ActiveMQConnectionFactory().createConnection();
                connection.start();
                Session session = connection.createSession(false, 1);
                session.createConsumer((Destination)new ActiveMQQueue("Orders.IBM"));
                session.createConsumer((Destination)new ActiveMQQueue("Orders.MSFT"), "price > 100");
                Session session2 = connection.createSession(false, 1);
                session2.createConsumer((Destination)new ActiveMQQueue("Orders.MSFT"), "price > 200");
            } else {
                broker.waitUntilStopped();
            }
        }
        catch (Exception e) {
            System.out.println("Failed: " + e);
            e.printStackTrace();
        }
    }
}

